#include "mbed.h"
#include "EntropyPool.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);

EntropyPool pool;
AnalogIn noise1(p15);
AnalogIn noise2(p16);
AnalogIn noise3(p17);
AnalogIn noise4(p18);
AnalogIn noise5(p19);
AnalogIn noise6(p20);

void gatherEntropy()
{
    pool.gatherAnalogNoise(noise1);
    pool.gatherAnalogNoise(noise2);
    pool.gatherAnalogNoise(noise3);
    pool.gatherAnalogNoise(noise4);
    pool.gatherAnalogNoise(noise5);
    pool.gatherAnalogNoise(noise6);
}

void write_block()
{
    led1 = 0; led2 = 1;
    while(pc.readable()) pc.getc();
    led2 = 0; led3 = 1;
    char* random = pool.produce(1024);
    led3 = 0; led4 = 1;
    for(int i = 0; i < 1024; ++i)
        pc.putc(random[i]);
    delete random;
    led4 = 0; led1 = 1;
}

int main() {
    pool.gatherer.attach(&gatherEntropy);
    
    // Disable ethernet to save power
    PHY_PowerDown();
    
    // Write at maximum warp
    pc.baud(115200);
    pc.attach(&write_block, Serial::RxIrq);
    
    // Sleep untill called
    while(1) Sleep();
}
