#ifndef RGBLEDPCA9555_H
#define RGBLEDPCA9555_H

#include "mbed.h"
#include "PCA9555.h"

class RgbLed {
public:
    RgbLed(PCA9555 *ioExt, unsigned int redPin, unsigned int greenPin, unsigned int bluePin); 
    
    enum Color {RED, GREEN, BLUE, CYAN, MAGENTA, YELLOW, WHITE, OFF};
    void setColor(Color color);
    void setRed(bool ledState);
    void setGreen(bool ledState);
    void setBlue(bool ledState);
    void toggleRed();
    void toggleGreen();
    void toggleBlue();
    void toggle();
    
private:
    PCA9555 *extIO;
    unsigned int ledR;
    unsigned int ledG;
    unsigned int ledB;
};

#endif