#include "rgb-led-pca9555.h"


RgbLed::RgbLed (PCA9555 *ioExt, unsigned int redPin, unsigned int greenPin, unsigned int bluePin): 
    extIO(ioExt), ledR(redPin), ledG(greenPin), ledB(bluePin)
    {
        setColor(OFF);        
}

void RgbLed::toggle() {
    extIO->togglePin(ledR);
    extIO->togglePin(ledG);
    extIO->togglePin(ledB);
}

void RgbLed::setColor(Color color) {
    switch (color) {
        case RED:
            extIO->clearPin(ledR);
            extIO->setPin(ledG);
            extIO->setPin(ledB);
            break;
        case GREEN:
            extIO->setPin(ledR);
            extIO->clearPin(ledG);
            extIO->setPin(ledB);
            break;
        case BLUE:
            extIO->setPin(ledR);
            extIO->setPin(ledG);
            extIO->clearPin(ledB);
            break;
        case CYAN:
            extIO->setPin(ledR);
            extIO->clearPin(ledG);
            extIO->clearPin(ledB);
            break;
        case MAGENTA:
            extIO->clearPin(ledR);
            extIO->setPin(ledG);
            extIO->clearPin(ledB);
            break;
        case YELLOW:
            extIO->clearPin(ledR);
            extIO->clearPin(ledG);
            extIO->setPin(ledB);
            break;
        case WHITE:
            extIO->clearPin(ledR);
            extIO->clearPin(ledG);
            extIO->clearPin(ledB);
            break;
        case OFF:
            extIO->setPin(ledR);
            extIO->setPin(ledG);
            extIO->setPin(ledB);
            break;
    }
}

void RgbLed::setRed(bool ledState) {
    if (ledState) {
        extIO->clearPin(ledR);
    } else {
        extIO->setPin(ledR);
    }
}

void RgbLed::setGreen(bool ledState) {
    if (ledState) {
        extIO->clearPin(ledG);
    } else {
        extIO->setPin(ledG);
    }
}

void RgbLed::setBlue(bool ledState) {
    if (ledState) {
        extIO->clearPin(ledB);
    } else {
        extIO->setPin(ledB);
    }
}

void RgbLed::toggleRed() {
    extIO->togglePin(ledR);
}

void RgbLed::toggleGreen() {
    extIO->togglePin(ledG);
}

void RgbLed::toggleBlue() {
    extIO->togglePin(ledB);
}