#ifndef MBED_PCA9555_H
#define MBED_PCA9555_H

#include "mbed.h"
 
/** Interface to the PCA9555 I2C 16 Bit IO expander */
class PCA9555 {
protected:
    InterruptIn     _irqpin;
    FunctionPointer _callbackChange;
public:
    /** Create an instance of the PCA9555 connected to specfied I2C pins, with the specified address.
     *
     * @param sda The I2C data pin
     * @param scl The I2C clock pin
     * @param interruptPin The pin connected to PCA9555 interrupt
     * @param address The I2C address for this PCA9555
     */
    PCA9555(PinName sda, PinName scl, PinName interrupPin, int address);
 
    /** Read the IO pin levels
     *
     * @return The two bytes read
     */
    int read();
    int getLastRead();
    /** Write to the IO pins
     * 
     * @param data The 16 bits to write to the IO port
     */
    void write(int data);
    
    /** Set one pin
     *
     * @param pinNumber The number of pin to set
     */
    void setPin(unsigned int pinNumber);
    
    /** Clear one pin
     *
     * @param pinNumber The number of pin to clear
     */
    void clearPin(unsigned int pinNumber);
    
    /** Toggle one pin
     *
     * @param pinNumber The number of pin to toggle
     */
    void togglePin(unsigned int pinNumber);
    
    /** Get state of pin
     *
     * @param pinNumber The number of pin
     */
    bool getPin(unsigned int pinNumber);
    void writePins();
    
    /** Set direction of pin
     *
     * @param pinNumber The number of pin to set
     */
    void setDirection(int data);
    
    void change(void (*function)(void));
    
    template<typename T>
    void change(T *object, void (T::*member)(void)) { 
        _callbackChange.attach(object, member); 
    }
 
private:
    I2C _i2c;
    int _address;
    unsigned int currentWriteState;
    unsigned int lastReadState;
    DigitalOut led3;
    int retryCount;
    int currentRetryCount;
    void callChange(void);
};
 
#endif