#include "PCA9555.h"
 
PCA9555::PCA9555(PinName sda, PinName scl, PinName interrupPin, int address)
        : _irqpin(interrupPin), _i2c(sda, scl), led3(LED3) {
    _address = address;    
    _irqpin.rise(this, &PCA9555::callChange);
    _irqpin.fall(this, &PCA9555::callChange);
    _i2c.frequency(400000);
    retryCount = 3;
    currentRetryCount = retryCount;
}

void PCA9555::setDirection(int data) {
    char foo[2];
    foo[0]=0x06;
    foo[1]=data;
    _i2c.write(_address, foo, 2);
    foo[0]=0x07;
    foo[1]=data>>8;
    _i2c.write(_address, foo, 2);
}
 
int PCA9555::read() {
    bool isCorrect = false;
    char rx_array[2] = {0x00, 0x00};
    char tx_array[1] = {0x00};
        
    while (--currentRetryCount) {
        tx_array[0] = 0x00;
        _i2c.write(_address, tx_array, 1);
        int success = _i2c.read(_address, rx_array, 2);
        //_i2c.stop();
        if (success != 0) {
            led3 = 1;
        } else {
            led3 = 0;
            currentRetryCount = retryCount;
            isCorrect = true;
            break;
        }
    }
    if (isCorrect) {
        lastReadState = (rx_array[1] << 8) | rx_array[0];
    }    
    return lastReadState;
}

int PCA9555::getLastRead() {
    return lastReadState;
}
 
void PCA9555::write(int data) {
    char foo[3];
    foo[0]=0x02;
    foo[1]=data;
    foo[2]=data>>8;
    _i2c.write(_address, foo, 3);
    /*char foo[2];
    foo[0]=0x02;
    foo[1]=data;
    _i2c.write(_address, foo, 2);
    foo[0]=0x03;
    foo[1]=data>>8;
    _i2c.write(_address, foo, 2);*/
}

void PCA9555::setPin(unsigned int pinNumber) {
    currentWriteState |= ((unsigned int)1 << pinNumber);
    //write(currentWriteState);
}

void PCA9555::clearPin(unsigned int pinNumber) {
    currentWriteState &= ~((unsigned int)1 << pinNumber);
    //write(currentWriteState);
}

void PCA9555::togglePin(unsigned int pinNumber) {
    currentWriteState ^= ((unsigned int)1 << pinNumber);
    //write(currentWriteState);
}

void PCA9555::writePins() {
    write(currentWriteState);
}

bool PCA9555::getPin(unsigned int pinNumber) {
    //return ballState;
    return (lastReadState & ((unsigned int)1 << pinNumber)) > 0;
}

void PCA9555::change(void (*function)(void)) {
    _callbackChange.attach(function);
}

void PCA9555::callChange(void) {
    read();
    _callbackChange.call();
}