#include "motor.h"

Motor::Motor(PinName PWMpin, PCA9555 *ioExt, unsigned int dir1Pin, unsigned int dir2Pin, PinName encA, PinName encB)
    : pwm(PWMpin), extIO(ioExt), dir1(dir1Pin), dir2(dir2Pin), qed(encA, encB) {
 
    PwmOut pwm(PWMpin);
    pwm.period_ms(1);
    setPoint = 0;
    pMulti = 16;
    iDiv = 1;
    dMulti = 1;
    error = 0;
    prevError = 0;
    P = 0;
    I = 0;
    minPwm = 100;
    pidMulti = 128;
    iMax = 512 * pidMulti;
    
    currentSpeed = 0;
    
    currentPWM = 0;
    stallCounter = 0;
    stallCounterLimit = 60;
}

void Motor::setPWM(int newPWM) {
    currentPWM = newPWM;
    if (newPWM < 0) {
        pwm.pulsewidth_us(-1 * newPWM);
        extIO->setPin(dir1);
        extIO->clearPin(dir2);
    } else {
        pwm.pulsewidth_us(newPWM);
        extIO->clearPin(dir1);
        extIO->setPin(dir2);
    }    
}

int Motor::getSpeed() {
    return currentSpeed;
}

int Motor::getDecoderCount() {
    currentSpeed = qed.read();
    return currentSpeed;
}

void Motor::setSpeed(int newSpeed) {
    setPoint = newSpeed;
    if (newSpeed == 0) {
        resetPID();
    }
}

void Motor::pid() {    
    prevError = error;
    error = setPoint - getDecoderCount();
    
    //float err = (float)error / 250.0;
    float minPwmValue = minPwm;
    
    if (setPoint == 0) {
        minPwmValue = 0;
    } else if (setPoint < 0) {
        minPwmValue = -minPwm;
    }
    
    I += error * pidMulti / iDiv;
    //constrain integral
    if (I < -iMax) I = -iMax;
    if (I > iMax) I = iMax;
    
    //D = error - prevError;
    
    //float newPWMvalue = minPwmValue + error * pMulti + I + dMulti * D;
    int newPWMvalue = minPwmValue + error * pMulti + I / pidMulti;

    //constrain pwm
    if (newPWMvalue < -1000) newPWMvalue = -1000;
    if (newPWMvalue > 1000) newPWMvalue = 1000;
    
    /*if ((currentSpeed < 5 && currentPWM == 1000 || currentSpeed > -5 && currentPWM == -1000) && stallCounter < stallCounterLimit) {
        stallCounter++;
    } else if (stallCounter > 0) {
        stallCounter++;
    }
    
    if (stallCounter == stallCounterLimit) {
        
    }*/
    
    setPWM(newPWMvalue);
}

void Motor::resetPID() {
    error = 0;
    prevError = 0;
    P = 0;
    I = 0;
    setPoint = 0;
    setPWM(0);
}

void Motor::stallWarning(void (*function)(void)) { 
    stallWarningCallback.attach(function);
}

void Motor::stallError(void (*function)(void)) { 
    stallErrorCallback.attach(function);
}