#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"
#include "PCA9555.h"
#include "qed.h"
 /** Class for controlling motors trough PCA9555 */
class Motor {
protected:
    FunctionPointer stallWarningCallback;
    FunctionPointer stallErrorCallback;
public:
    /** Create an instance of the motor connected to specfied pins, and IO-expander.
     *
     * @param PWMpin Pin for PWM output
     * @param *ioExt Pointer to IO-expander object
     * @param dir1Pin Direction pin 1 number (on IO-expander)
     * @param dir2Pin Direction pin 2 number (on IO-expander)
     * @param encA Encoder pin
     * @param encB Encoder pin
     */
    Motor(PinName PWMpin, PCA9555 *ioExt, unsigned int dir1Pin, unsigned int dir2Pin, PinName encA, PinName encB);
    
    /** Set speed setpoint
     *
     * @param newSpeed New setpoint
     */
    void setSpeed(int newSpeed);
    
    /** Get current speed setpoint value */
    int getSpeed();
    
    /**Method that calculates appropriate PWM values for keeping motor speed close to setpoint
    *     This method shoud be called periodically (60Hz)
    */
    void pid();
    
    void stallWarning(void (*function)(void));
    
    template<typename T>
    void stallWarning(T *object, void (T::*member)(void)) { 
        stallWarningCallback.attach(object, member); 
    }
    
    void stallError(void (*function)(void));
    
    template<typename T>
    void stallError(T *object, void (T::*member)(void)) { 
        stallErrorCallback.attach(object, member); 
    }
 
private:
    PwmOut pwm;
    PCA9555 *extIO;
    unsigned int dir1;
    unsigned int dir2;
    QED qed;
    
    int currentSpeed;
    int getDecoderCount();
    
    void resetPID();
    
<<<<<<< local
=======
    /** Set pwm duty cycle
     *
     * @param newPWM Duty cycle
     */
    void setPWM(int newPWM);
    
    //void pid();
    
>>>>>>> other
    int setPoint;
    int pMulti;
    int iDiv;
    int dMulti;
    int error;
    int prevError;
    int P;
    int I;
    int D;
    int minPwm;
    int pidMulti;
    int iMax;
    
    int currentPWM;
    int stallCounter;
    int stallCounterLimit;
};

#endif