#ifndef MCP3021_H
 
#define MCP3021_H
 
#include "mbed.h"
 
#define    MCP3021_CONVERSE 0x9B //10011011 NOTE IT ENDS IN 1, this is the READ ADDRESS. This is all this device does.
                                 //It opens a conversation via this specific READ address
 
//Library for the MCP3021 12 BIT ADC.
 
class MCP3021
{
public:
 
  /*
  Creates instance
  Connect module using I2C port pins sda and scl. The output is referenced to the supply voltage which can be
  2.7v to 5.0v. The read will return the correct voltage, if you supply the correct supplyVoltage when instantiating.
  */
  MCP3021(PinName sda, PinName scl, float supplyVoltage);
  
  /*
  Destroys instance.
  */ 
  ~MCP3021();
  
  /*
  Reads the analog register of the MCP3021 and converts it to a useable value. (a voltage) 
  */
  float read();
  
private:
  
  I2C i2c;
  float _supplyVoltage;
  char _data[2];
 
};
 
#endif