#ifndef HUMANINTERFACE_H
#define HUMANINTERFACE_H

#include "mbed.h"
#include "PCA9555.h"
#include "externalin.h"
#include "Serial.h"
#include "PinDetect.h"
#include "rgb-led-pca9555.h"

class HumanInterface {
public:
    HumanInterface(
        PCA9555 *ioExt,
        unsigned int redLed1Pin, unsigned int greenLed1Pin, unsigned int blueLed1Pin,
        unsigned int redLed2Pin, unsigned int greenLed2Pin, unsigned int blueLed2Pin,
        PinName goalButtonPin, PinName startButtonPin, PinName ballSensePin
    ); 
    
    enum Goal {YELLOW, BLUE, UNSET};
    void setGoal(Goal goal);
    void setError(bool state);
    void setGo(bool state);    
    
    bool isGoalChange();
    bool isStart();
    int getBallState();
    
private:
    Serial *pc;
    
    PCA9555 *extIO;
    
    RgbLed rgbLed1;
    RgbLed rgbLed2;
    
    PinDetect buttonGoal;
    PinDetect buttonStart;
    //PinDetect inputBall;    
    
    InterruptIn inputBall;
       
    //Functions that PinDetect will call
    void goalFall();
    void startRise();
    void ballFall();
    void ballRise();
    
    bool goalButtonPressed;
    bool startButtonReleased;
    int ballState;
   
    bool redBlinking;
    bool goalBlinking;
    
    bool redState();

    Ticker ledTicker;
    
    void blinkLeds(void);
};

#endif