#include "HumanInterface.h"


HumanInterface::HumanInterface (PCA9555 *ioExt,
    unsigned int redLed1Pin, unsigned int greenLed1Pin, unsigned int blueLed1Pin,
    unsigned int redLed2Pin, unsigned int greenLed2Pin, unsigned int blueLed2Pin,
    PinName goalButtonPin, PinName startButtonPin, PinName ballSensePin):
    extIO(ioExt), 
    rgbLed1(ioExt, redLed1Pin, greenLed1Pin, blueLed1Pin),
    rgbLed2(ioExt, redLed2Pin, greenLed2Pin, blueLed2Pin),
    buttonGoal(goalButtonPin), buttonStart(startButtonPin), inputBall(ballSensePin)
    {
        goalButtonPressed = false;
        startButtonReleased = false;
        ballState = 0;
        
        buttonGoal.mode(PullUp);
        buttonStart.mode(PullUp);
        
        buttonGoal.attach_deasserted(this, &HumanInterface::goalFall);
        buttonStart.attach_asserted(this, &HumanInterface::startRise);
        //inputBall.attach_asserted(this, &HumanInterface::ballRise);
        //inputBall.attach_deasserted(this, &HumanInterface::ballFall);
        
        inputBall.rise(this, &HumanInterface::ballRise);
        inputBall.fall(this, &HumanInterface::ballFall);
        
        buttonGoal.setSamplesTillAssert(20);
        buttonStart.setSamplesTillAssert(20);
        //inputBall.setSamplesTillAssert(2);
        
        buttonGoal.setSampleFrequency(1000);
        buttonStart.setSampleFrequency(1000);
        //inputBall.setSampleFrequency(5000);
        
        redBlinking = false;
        goalBlinking = false;

        setGoal(UNSET);

        ledTicker.attach(this, &HumanInterface::blinkLeds, 0.2);
        
}

void HumanInterface::setError(bool state) {
    if (state) {
        redBlinking = true;
        rgbLed2.setGreen(false);
        rgbLed2.setColor(RgbLed::RED);
    } else {
        redBlinking = false;
        rgbLed2.setRed(false);
    }
}

void HumanInterface::setGo(bool state) {
    if (state) {
        rgbLed2.setColor(RgbLed::GREEN);
        redBlinking = false;
    } else {
        rgbLed2.setGreen(false);
    }
}

void HumanInterface::setGoal(Goal goal) {
    if (goal == YELLOW) {
        rgbLed1.setColor(RgbLed::YELLOW);
        goalBlinking = false;
    } else if (goal == BLUE) {
        rgbLed1.setColor(RgbLed::BLUE);
        goalBlinking = false;
    } else if (goal == UNSET) {
        rgbLed1.setColor(RgbLed::YELLOW);
        goalBlinking = true;
    }
}

void HumanInterface::blinkLeds(void) {
    if (redBlinking)
        rgbLed2.toggleRed();
    if (goalBlinking)
        rgbLed1.toggle();
}



int HumanInterface::getBallState() {
    //int ret = ballState;
    //ballState = 0;
    return ballState;
}

bool HumanInterface::isGoalChange() {
    bool ret = goalButtonPressed;
    goalButtonPressed = false;
    return ret;
}

bool HumanInterface::isStart() {
    bool ret = startButtonReleased;
    startButtonReleased = false;
    return ret;
}

void HumanInterface::goalFall() {
    goalButtonPressed = true;
}

void HumanInterface::startRise() {
    startButtonReleased = true;
}

void HumanInterface::ballRise() {
    ballState = 1;
    rgbLed2.setColor(RgbLed::MAGENTA);
}

void HumanInterface::ballFall() {
    ballState = 0;
    rgbLed2.setColor(RgbLed::OFF);
}
