#include "HumanInterface.h"


HumanInterface::HumanInterface (PCA9555 *ioExt,
    unsigned int yellowLedPin, unsigned int blueLedPin, unsigned int redLedPin,
    unsigned int greenLedPin, unsigned int orangeLedPin,
    PinName goalButtonPin, PinName startButtonPin, PinName ballSensePin):
    extIO(ioExt), redLed(ioExt, redLedPin), blueLed(ioExt, blueLedPin), yellowLed(ioExt, yellowLedPin),
    greenLed(ioExt, greenLedPin), orangeLed(ioExt, orangeLedPin),
    /*interruptGoal(goalButtonPin), interruptStart(startButtonPin), interruptBall(ballSensePin)*/
    buttonGoal(goalButtonPin), buttonStart(startButtonPin), inputBall(ballSensePin)
    {
        goalButtonPressed = false;
        startButtonReleased = false;
        ballState = 0;
        
        buttonGoal.mode(PullUp);
        buttonStart.mode(PullUp);
        
        buttonGoal.attach_deasserted(this, &HumanInterface::goalFall);
        buttonStart.attach_asserted(this, &HumanInterface::startRise);
        inputBall.attach_asserted(this, &HumanInterface::ballRise);
        inputBall.attach_deasserted(this, &HumanInterface::ballFall);
        
        buttonGoal.setSamplesTillAssert(20);
        buttonStart.setSamplesTillAssert(20);
        inputBall.setSamplesTillAssert(2);
        
        buttonGoal.setSampleFrequency(1000);
        buttonStart.setSampleFrequency(1000);
        inputBall.setSampleFrequency(250);
        
        
        redBlinking = false;
        blueBlinking = false;
        yellowBlinking = false;
        greenBlinking = false;
        orangeBlinking = false;

        setGoal(UNSET);

        ledTicker.attach(this, &HumanInterface::blinkLeds, 0.2);
        
}

void HumanInterface::setError(bool state) {
    if (state) {
        redBlinking = true;
    } else {
        redBlinking = false;
        redLed.clear();
    }
}

void HumanInterface::setGo(bool state) {
    if (state) {
        greenLed.set();
    } else {
        greenLed.clear();
    }
}

void HumanInterface::setGoal(Goal goal) {
    if (goal == YELLOW) {
        yellowLed.set();
        blueLed.clear();
        blueBlinking = false;
        yellowBlinking = false;
    } else if (goal == BLUE) {
        yellowLed.clear();
        blueLed.set();
        blueBlinking = false;
        yellowBlinking = false;
    } else if (goal == UNSET) {
        yellowLed.clear();
        blueLed.clear();
        blueBlinking = true;
        yellowBlinking = true;
    }
}

void HumanInterface::blinkLeds(void) {
    if (redBlinking)
        redLed.toggle();
    if (blueBlinking)
        blueLed.toggle();
    if (yellowBlinking)
        yellowLed.toggle();
    if (greenBlinking)
        greenLed.toggle();
    if (orangeBlinking)
        orangeLed.toggle();
}



int HumanInterface::getBallState() {
    int ret = ballState;
    ballState = 0;
    return ret;
}

bool HumanInterface::isGoalChange() {
    bool ret = goalButtonPressed;
    goalButtonPressed = false;
    return ret;
}
bool HumanInterface::isStart() {
    bool ret = startButtonReleased;
    startButtonReleased = false;
    return ret;
}


void HumanInterface::goalFall() {
    goalButtonPressed = true;
}

void HumanInterface::startRise() {
    startButtonReleased = true;
}

void HumanInterface::ballRise() {
    ballState = 1;
}

void HumanInterface::ballFall() {
    ballState = -1;
}
