#ifndef HUMANINTERFACE_H
#define HUMANINTERFACE_H

#include "mbed.h"
#include "PCA9555.h"
#include "externalin.h"
#include "ledout.h"
#include "Serial.h"
#include "PinDetect.h"

class HumanInterface {
public:
    HumanInterface(
        PCA9555 *ioExt,
        unsigned int yellowLedPin, unsigned int blueLedPin, unsigned int redLedPin,
        unsigned int greenLedPin, unsigned int orangeLedPin,
        PinName goalButtonPin, PinName startButtonPin, PinName ballSensePin
    ); 
    
    enum Goal {YELLOW, BLUE, UNSET};
    void setGoal(Goal goal);
    void setError(bool state);
    void setGo(bool state);    
    
    bool isGoalChange();
    bool isStart();
    int getBallState();
    
private:
    Serial *pc;
    
    PCA9555 *extIO;
    
    LedOut redLed;
    LedOut blueLed;
    LedOut yellowLed;
    LedOut greenLed;
    LedOut orangeLed;
    
    PinDetect buttonGoal;
    PinDetect buttonStart;
    PinDetect inputBall;
    
       
    //Functions that PinDetect will call
    void goalFall();
    void startRise();
    void ballFall();
    void ballRise();
    
    bool goalButtonPressed;
    bool startButtonReleased;
    int ballState;
   
    bool redBlinking;
    bool blueBlinking;
    bool yellowBlinking;
    bool greenBlinking;
    bool orangeBlinking;

    Ticker ledTicker;
    
    void blinkLeds(void);
};

#endif