#ifndef EXTERNALIN_H
#define EXTERNALIN_H

#include "mbed.h"
#include "PCA9555.h"

class ExternalIn {
protected:
    FunctionPointer _callbackChange;
public:
    ExternalIn(PCA9555 *ioExt, unsigned int pin);
    ExternalIn(PCA9555 *ioExt, unsigned int pin, bool defaultState);
    bool read();
    
    void change(void (*function)(void));
    
    template<typename T>
    void change(T *object, void (T::*member)(void)) { 
        _callbackChange.attach(object, member); 
    }   
    
private:
    bool pinState;
    PCA9555 *extIO;
    unsigned int inPin;
    
    void callChange(void);        
    
    void setState(bool newState);
};

#endif