#include "externalin.h"

ExternalIn::ExternalIn(PCA9555 *ioExt, unsigned int pin)
    : extIO(ioExt), inPin(pin) {
    
    pinState = false;
 
    extIO->change(this, &ExternalIn::callChange);
}

ExternalIn::ExternalIn(PCA9555 *ioExt, unsigned int pin, bool defaultState)
    : extIO(ioExt), inPin(pin), pinState(defaultState) {
    
    extIO->change(this, &ExternalIn::callChange);
}

bool ExternalIn::read() {
    return extIO->getPin(inPin);
}

void ExternalIn::setState(bool newState) {
    bool oldState = pinState;
    pinState = newState;
    /*if (oldState != newState) {
        _callbackChange.call();
    }*/
}

void ExternalIn::change(void (*function)(void)) { 
    _callbackChange.attach(function);
}
/*
template<typename T>
void BallSens::change(T *object, void (T::*member)(void)) { 
    _callbackChange.attach(object, member); 
}
*/
void ExternalIn::callChange(void) {
    //setState((extIO->read() & ((unsigned int)1 << inPin)) > 0);
    _callbackChange.call();
}