#ifndef COILGUN_H
#define COILGUN_H
 
#include "mbed.h"
 
/** Class for controlling coilgun */
class Coilgun {
public:
    /** Create an instance of the Coilgun connected to specfied pins */
    Coilgun(PinName kickPinName, PinName chipPinName, PinName chargePinName, PinName donePinName);
    
    /** Kick with coilgun */
    void kick(unsigned int kickLength, unsigned int kickDelay, unsigned int chipLength, unsigned int chipDelay);
    /** Stop kick */
    void kickEnd(void);
    void chipEnd(void);
    
    /** Charge capacitor */
    void charge(void);
    /** Stop charging capacitor */
    void chargeEnd(void);
    
    /** Discharge capacitor */
    void discharge(void);
    /** Stop discharging */
    void dischargeEnd(void);
    
    /** Read only
     * Will be set to true, when charge() is called,
     * false, when discharge is called.
     * NB! if discharge is interrupted, capacitor may still have some charge on it.
     */
    bool isCharged;
    
private:
    enum State {idle, kicking, charging, discharging};
    State state;
    
    unsigned int currentKickLength;
    unsigned int currentKickDelay;
    unsigned int currentChipLength;
    unsigned int currentChipDelay;
    
    DigitalOut kickPin;
    DigitalOut chipPin;
    DigitalOut chargePin;
    InterruptIn donePin;
 
    Timeout kickTimeout; // This will end kicking
    Timeout kickDelayTimeout;
    Timeout chipTimeout;
    Timeout chipDelayTimeout;
    
    bool kickActive;
    bool chipActive;
    
    Timeout dischargeTimeout; // This will end discharging
    Ticker discharger; // Calls short kicks during discharge
    
    void kickDelayEnd(void);
    void chipDelayEnd(void);
    
    void changeState(State new_state);
    void dischargeKick(void);
    void kick(unsigned int kickLength, unsigned int kickDelay, unsigned int chipLength, unsigned int chipDelay, bool change_state);
};
 
#endif