#include "coilgun.h"
 
Coilgun::Coilgun(PinName kickPinName ,PinName chargePinName, PinName donePinName): 
    kickPin(kickPinName),chargePin(chargePinName), donePin(donePinName) 
{
    isCharged = false;
    state = idle;
    kickPin = 1;
    chargePin = 0;
    //donePin.fall(this, &Coilgun::chargeEnd);
    
    discharge(); // For safety reasons.
}

void Coilgun::kick(unsigned int length) {
    kick(length,true);
}

void Coilgun::kick(unsigned int length, bool change_state = true) {
    if (change_state) {//Used to keep state when discharging
        changeState(kicking);
    }
    
    chargePin = 0; // Maybe not needed anymore? (still a safety?)
    kickPin = 0;
    kickTimeout.attach_us(this, &Coilgun::kickEnd, length);
}

void Coilgun::kickEnd(void) {
    kickTimeout.detach();
    kickPin = 1;

    if (state != discharging){ //Used when discharging 
        chargePin = 1; // Don't start charging again
        state = idle; //(let state stay "discharging")
    }
    
}

void Coilgun::charge() {
    changeState(charging);
    kickPin = 1;
    chargePin = 1; 
    isCharged = true;
}

void Coilgun::chargeEnd(){
    chargePin = 0;
    state = idle;
}

void Coilgun::discharge() {
    changeState(discharging);
    dischargeTimeout.attach(this, &Coilgun::dischargeEnd, 10.0); // End discharging after 10 seconds
    discharger.attach_us(this, &Coilgun::dischargeKick, 5000); // calls short kick every 5ms
    isCharged = false;
}

void Coilgun::dischargeEnd(void) {
    discharger.detach();
    state = idle;
}

void Coilgun::dischargeKick(void) {
    kick(500, false);
}

void Coilgun::changeState(State new_state){
    switch(state){
        case idle:
            //nothing to end.
            break;
        case kicking:
            kickEnd();
            break;
        case charging:
            chargeEnd();
            break;
        case discharging:
            dischargeEnd();
            break;
        default:
            //error - no such state
            break;
    }
    //set new state
    state = new_state;
}