#ifndef COILGUN_H
#define COILGUN_H
 
#include "mbed.h"
 
/** Class for controlling coilgun */
class Coilgun {
public:
    /** Create an instance of the Coilgun connected to specfied pins */
    Coilgun(PinName kickPinName ,PinName chargePinName, PinName donePinName);
    
    /** Kick with coilgun */
    void kick(unsigned int length);
    /** Stop kick */
    void kickEnd(void);
    
    /** Charge capacitor */
    void charge(void);
    /** Stop charging capacitor */
    void chargeEnd(void);
    
    /** Discharge capacitor */
    void discharge(void);
    /** Stop discharging */
    void dischargeEnd(void);
    
    /** Read only
     * Will be set to true, when charge() is called,
     * false, when discharge is called.
     * NB! if discharge is interrupted, capacitor may still have some charge on it.
     */
    bool isCharged;
    
private:
    enum State {idle, kicking, charging, discharging};
    State state;
    
    DigitalOut kickPin;
    DigitalOut chargePin;
    InterruptIn donePin;
 
    Timeout kickTimeout; // This will end kicking
    Timeout dischargeTimeout; // This will end discharging
    Ticker discharger; // Calls short kicks during discharge
    
    void changeState(State new_state);
    void dischargeKick(void);
    void kick(unsigned int length, bool change_state);
};
 
#endif