#ifndef BALLSENS_H
#define BALLSENS_H

#include "mbed.h"
#include "PCA9555.h"

class BallSens {
protected:
    FunctionPointer _callbackChange;
public:
    BallSens(PCA9555 *ioExt, unsigned int ballPin);
    bool read();
    
    void change(void (*function)(void));
    
    template<typename T>
    void change(T *object, void (T::*member)(void)) { 
        _callbackChange.attach(object, member); 
    }   
    
private:
    bool ballState;
    PCA9555 *extIO;
    unsigned int ballPinNumber;
    
    void callChange(void);        
    
    void setState(bool newState);
};

#endif