#include "ballsens.h"

BallSens::BallSens(PCA9555 *ioExt, unsigned int ballPin)
    : extIO(ioExt), ballPinNumber(ballPin) {
    
    ballState = false;
 
    extIO->change(this, &BallSens::callChange);
}

bool BallSens::read() {
    //return ballState;
    return (extIO->read() & 0x0400) > 0;
}

void BallSens::setState(bool newState) {
    bool oldState = ballState;
    ballState = newState;
    /*if (oldState != newState) {
        _callbackChange.call();
    }*/
}

void BallSens::change(void (*function)(void)) { 
    _callbackChange.attach(function);
}
/*
template<typename T>
void BallSens::change(T *object, void (T::*member)(void)) { 
    _callbackChange.attach(object, member); 
}
*/
void BallSens::callChange(void) {
    setState((extIO->read() & 0x0400) > 0);
    _callbackChange.call();
}