#ifndef A3930_H
#define A3930_H

#include "mbed.h"
#include "PCA9555.h"
#include "PinDetect.h"

 /** Class for controlling motors trough PCA9555 */
class A3930 {
protected:
    FunctionPointer stallChangeCallback;
    FunctionPointer stallEndCallback;
    FunctionPointer stallWarningCallback;
    FunctionPointer stallErrorCallback;
public:
    /** Create an instance of the motor connected to specfied pins, and IO-expander.
     *
     * @param PWMpin Pin for PWM output
     * @param *ioExt Pointer to IO-expander object
     * @param dir1Pin Direction pin 1 number (on IO-expander)
     * @param dir2Pin Direction pin 2 number (on IO-expander)
     * @param encA Encoder pin
     * @param encB Encoder pin
     */
    A3930(PinName PWMpin, PCA9555 *ioExt, unsigned int dirPin, unsigned int brakePin, unsigned int coastPin, PinName tachoPin, PinName diroPin);
    
    /** Set speed setpoint
     *
     * @param newSpeed New setpoint
     */
    void setSpeed(int newSpeed);
    
    /** Get current speed setpoint value */
    int getSpeed();
    
    /**Method that calculates appropriate PWM values for keeping motor speed close to setpoint
    *     This method shoud be called periodically (60Hz)
    */
    void pid();
    
    /** Set pwm duty cycle
     *
     * @param newPWM Duty cycle
     */
    void setPWM(float newPWM);
    
    void setRawPWM(float newPWM);
    
    int getStallLevel();
    
    void stallChange(void (*function)(void));
    
    template<typename T>
    void stallChange(T *object, void (T::*member)(void)) { 
        stallChangeCallback.attach(object, member); 
    }
    
    void stallEnd(void (*function)(void));
    
    template<typename T>
    void stallEnd(T *object, void (T::*member)(void)) { 
        stallEndCallback.attach(object, member); 
    }
    
    void stallWarning(void (*function)(void));
    
    template<typename T>
    void stallWarning(T *object, void (T::*member)(void)) { 
        stallWarningCallback.attach(object, member); 
    }
    
    void stallError(void (*function)(void));
    
    template<typename T>
    void stallError(T *object, void (T::*member)(void)) { 
        stallErrorCallback.attach(object, member); 
    }
 
private:
    PwmOut pwm;
    PCA9555 *extIO;
    unsigned int dirPinNumber;
    unsigned int brakePinNumber;
    unsigned int coastPinNumber;
    
    InterruptIn interruptTacho;
    //InterruptIn interruptDiro;
    
    //PinDetect interruptTacho;
    PinDetect interruptDiro;
    
    volatile int diro;
    volatile int pulses;
    
    int currentSpeed;
    int getDecoderCount();
    
    void tachoChanged();
    void diroRise();
    void diroFall();
    
    void resetPID();

    int setPoint;
    float pMulti;
    float iMulti;
    float dMulti;
    int error;
    int prevError;
    float P;
    float I;
    float D;
    float minPwm;
    
    float pwmPeriod;
    
    float currentPWM;
    int stallCount;
    int prevStallCount;
    int stallWarningLimit;
    int stallErrorLimit;
    int stallLevel;
};

#endif