#include "mbed.h"


 
// ---------------- Serial RS232 Event Class  --------------------------
const uint8_t STRMAX = 20;  // const = Konstante Variable --> Varable mit einen bestimmte Typ der immer gleich bleibt 
const char EOT = '.';       // const = Konstante Variable --> Varable mit einen bestimmte Typ der immer gleich bleibt 
const char CRLF = '\n';     // const = Konstante Variable --> Varable mit einen bestimmte Typ der immer gleich bleibt 
 
class SerialEvent {         // classe erstellen und weisen den Namen zu
        Serial _pc;         // Ertellen des Objekts _pc aus der Klasse Serial 
        void _risingISR();  // Methode erstellen
        char _str[STRMAX];  // Es wird ein String erstellt mit der Maximallänge von STRMAX(20)
        volatile bool _strOkFlag; // VOLATILE --> Wert zur Laufzeit  bool--> Datentyp _strOkFlag --> Name der Variable
        int _index;         // Variable mit dem Datentyp Int
 
    // Public Ist öffentlich und von extern zugänglich 
    public:    
        // SerialEvent --> Konstruktor / PinName --> PIN bezeichnung vom Mbed / tx --> übergabeparameter / : --> kurzzuweisung   
        SerialEvent(PinName tx, PinName rx) : _pc(tx, rx) { // create the Serial on the pin specified to SwEvent
        // attach --> anhängen / Obejekt SerialEvent / & --> Pointer / pc_recv --> Funktion / :: braucht man wenn es auserhalb der Classe steht aber zur Classe gehört
            _pc.attach(callback(this, &SerialEvent::pc_recv));        // attach DataReceive-function of this SerialEvent instance 
            _strOkFlag = false;  // Variable zuweisen auf false
            _index=0;            // Variable zuweisen auf 0
 
        }
        void pc_recv();     // Methode prototyping ( Namendliche erwähnung in der Klasse damit der Combiler weis, dass die Funktion vorhanden ist
        void getString(char st[]);  // Methode prototyping ( Namendliche erwähnung in der Klasse damit der Combiler weis, dass die Funktion vorhanden ist
        int checkFlag();                    // must in do-condition (while(true)-loop) continuously interrogated
};
 
// ---------------- Serial Event Class Methodes --------------------------
void SerialEvent::getString(char st[]) {
    for( int i=0; i <= _index; i++)
        st[i] = _str[i];
    _index=0;
}
 
void SerialEvent::pc_recv() {
    char c;
    while(_pc.readable()){   // _pc.readable schaut nach ob Daten im Puffer zum auslesen sind oder nicht
        c = _pc.getc();
        if((c != CRLF) && (_index < STRMAX)) {
            _str[_index++] = c;
        }
    }
    if(( c == EOT)) {           // end: . string not empty
        if(_index >= 1) {
            _strOkFlag = true;
            _str[--_index] = 0; 
        }
    }
}
 
int SerialEvent::checkFlag() {
    if( _strOkFlag ) {
        _strOkFlag = false; 
        return 1;
    }
    return 0;
}
 
SerialEvent se(USBTX, USBRX);
char str[STRMAX];
 
int main() {
    printf("Hello\n");
    while(1) {
        if(se.checkFlag()) {
            se.getString(str);
            printf("String: %s\n", str);
        }
}
}