#include "mbed.h"

InterruptIn iiJsUp(p15);
InterruptIn iiJsDown(p12);
InterruptIn iiJsLeft(p13);
InterruptIn iiJsRight(p16);
InterruptIn iiJsCenter(p14);
BusOut doLeds (LED1, LED2, LED3, LED4);

int Zaehler = 7; 

void Up()
{
    if(Zaehler <= 30)
    Zaehler += 1;
    
    wait(0.25);
}
void Down()
{
    if(Zaehler <= 30)
    Zaehler += 5;
    
    wait(0.25);
}
void Left()
{
    if(Zaehler >= -20)
    Zaehler -= 1;
    
    wait(0.25);
}
void Right()
{
    if(Zaehler >= -20)
    Zaehler -= 5;
    
    wait(0.25);
}
void Zaehlerstand()
{
    printf("Zaehlerstand = %d; Matthias Reichstam\r\n", Zaehler);
    wait(0.25);
}

int main() {
    
    iiJsUp.rise(&Up);
    iiJsDown.rise(&Down);
    iiJsLeft.fall(&Left);
    iiJsRight.fall(&Right);
    
    iiJsCenter.rise(&Zaehlerstand);
    
    printf("BULME: Joystick-Zaehler ; 29.01.2018 ; Matthias Reichstam\r\n");

    
    
    while(1) 
    {
        if(Zaehler <= 30 && Zaehler >= -20) 
        {
            doLeds = 6;
        }
        else if(Zaehler > 30)
        {
            doLeds = 12;
            wait(0.2);
            doLeds = 0;
            wait(0.2);
        }
        else if(Zaehler < -20)
        {
            doLeds = 3;
            wait(0.5);
            doLeds = 0;
            wait(0.5);
        }
        

    }
}
