// Stopuhr: min:sec:hsec am LCD
// Start: Joystick Up
// Stopp: Joystick Down
// Reset: Joystick  Center (sets value to 0 and retarts ..)

#include "mbed.h"
#include "C12832_lcd.h"

InterruptIn iiUp(p15);
DigitalIn diUp(p15);
InterruptIn iiDown(p12);
DigitalIn diDown(p12);
InterruptIn iiCenter(p14);
DigitalIn diCenter(p14);
Ticker myTimer;
uint32_t hSec;
bool runFlag = false;
bool updateLcd = true;

// prototypes

// functions
// Diese Funktion ist zum Entprellen von Tastern geeignet: 
// Durch den zusätzlichen Code kann eine Entprellzeit von durchschnittlich 1,5-4ms
// (mindestens 8*150us = 1,2ms) erreicht werden. 
// Grundsätzlich prüft die Funktion den Pegel des Pins eine DigitalIn. 
// Wenn der Pegel 8 Mal konstant war, wird die Schleife verlassen. 
// Diese Funktion kann sehr gut eingesetzt werden, um in einer Endlosschleife Taster 
// anzufragen, da sie, wie erwähnt, eine kurze Wartezeit hat.
uint8_t debounce(DigitalIn myIn)  
{
    #define LEVEL_CHECKS 8
    #define MAX_LOOPS 30                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;
    
    do
    {
        port_buffer = myIn;
        wait_us(100);
        loopCounter++;
        if(myIn == port_buffer)
          debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
          debounceCounter = 0;      
    }
    while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}

// ISR
void cntUp() { // Start stop watch
    debounce(diUp);
    runFlag = true;
}

void cntDown() { // Stopp stop watch
    debounce(diDown); 
    runFlag = false; 
    updateLcd = true;   
}    

void cntReset() { // reset stop watch
    debounce(diCenter); 
    hSec = 0;
    updateLcd = true; 
}

void count10msec(void) {
    if (runFlag) {
        hSec++; 
        if (hSec%10 == 0)   // update every 100 msec
            updateLcd = true;
    }  
}

// main program
int main() {
    uint32_t tempHsec=0;
    uint8_t sec=0;
    uint16_t min=0;
    C12832_LCD lcd;
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Matthias Reichstam Stopuhr");
    iiUp.rise(&cntUp);
    iiDown.rise(&cntDown);
    iiCenter.rise(&cntReset);
    myTimer.attach(&count10msec, 0.01); // Hunderstel-Sec
    
    while(1) { 
        if (updateLcd) {
            updateLcd = false;
            lcd.locate(0,10);
            tempHsec = hSec;
            min = tempHsec/(100*60);
            sec = tempHsec/100 - min*60;
            lcd.printf("%02u:%02u:%02u", min, sec, tempHsec%100);
        }
    }
}

