#include "mbed.h"
#include "LM75B.h"

LM75B tmp(p28, p27);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn sw1(p14);
InterruptIn sw2(p15);

void flipper(void);
void ON(void);
void IDLE(void);
void sw1Rise(void);
void sw2Rise(void);
void Time(void);
void TimeOut(void);
void Blink(void);
void tempOut(void);
void timeOutError(void);
void errorBlink(void);
void timeover(void);
bool checker(void);
bool checkerSW2(void);
bool volatile sw2Pressed;
bool volatile sw1Pressed;

Timeout removeTime;
Timer gettime;
Ticker tickerflipper;
int counter;

enum Status{ST_IDLE=0, ST_ON, ST_TimeOut, ST_TempOut, ST_Error};
Status volatile status;

int main(void)
{
    sw1.rise(&sw1Rise);
    sw2.rise(&sw2Rise);
    status = ST_IDLE;
    sw1Pressed = 0;
    sw2Pressed = 0;
    counter=0;
    led1=0, led2=0, led3=0, led4=0;
    
    while(1)
    {
        switch(status)
        {
            case ST_IDLE:IDLE()         ; break;
            case ST_ON:ON()             ; break;
            case ST_TimeOut:TimeOut()   ; break;
            case ST_TempOut:tempOut()   ; break;
            case ST_Error:timeover()    ; break;
        }
    }
}

void timeover(void)
{
    printf("Ende gut, Alles gut\n");
    while(1)
    {}
}

void errorBlink(void)
{
 led4 = !led4;
 
}
void timeOutError(void)
{
    status = ST_Error;
    printf("Error TimeOut\n");
    printf("Status: %i\n", status);
}

void tempOut(void)
{
    int countertmp = 0;
    
    printf("void tempOut\n");
    while(1)
    {
     printf("Temperatur: %f\n",tmp.read());
     if(checkerSW2() == true)
     {
         status = ST_ON;
         return;
     }   
     countertmp++;
     wait(1);
    }
}

void flipper(void)
{
    printf("void flipper\n");
    led4 = !led4;
    if(counter == 3)
    {
     tickerflipper.detach();   
     counter=0;
    }
    else
    counter++; 
}

void TimeOut(void)
{
    printf("void TimeOut\n");
    int counterto = 0;
    while(1)
    {
        printf("TimeOut: %i\n", counterto);
        counterto++;
        wait(1);
        
    if(checkerSW2() == true)
    {
        status = ST_TempOut;
        return;
    }
    }
}

void Time(void)
{
    printf("void Time\n");
    if (gettime.read() ==0)
    {
        gettime.start();
    }
    
    else
        printf("Secunden: %f\n", gettime.read());
        gettime.reset();
}

bool checker(void)
{
    if(sw1Pressed == true)
    {
        printf("void checker\n");
        Time();
        sw1Pressed = false;
        return true;
    }
    return false;
}

bool checkerSW2(void)
{
    if(sw2Pressed == true)
    {
        printf("void checkerSW2\n");
        sw2Pressed = false;
        return true;
    }
    return false;
}
    

void sw1Rise(void)
{   
    printf("sw1Rise\n");
    
    if(status == ST_ON || status == ST_IDLE) sw1Pressed = 1;
    wait_ms(200);
}

void sw2Rise(void)
{
    printf("void sw2Rise\n");
    if(status == ST_ON || status == ST_TimeOut || status == ST_TempOut)  sw2Pressed = 1;
    wait_ms(200);
}

void ON(void)
{
    printf("void ON\n");
    tickerflipper.attach(&flipper, 0.5);
    removeTime.attach(&timeOutError, 10);
    led1 = true; 
    
    while(1)
    {
        if(status == ST_Error)
        {
            printf("IDLE verlassen\n");
            tickerflipper.attach(&errorBlink, 0.3);
            led1=false;
        return;
        }
        if(checkerSW2() == true)
        {
            status = ST_TimeOut;
            removeTime.detach();
            return;
        }
        if (checker() == true)
        {
            status = ST_IDLE;
            removeTime.detach();
            led1=false;
            return;
        }
    }
}

void IDLE(void)
{
    printf("void IDLE\n");
    removeTime.attach(&timeOutError, 10);
    while(1)
    {
        if(status == ST_Error)
        {
            printf("IDLE verlassen\n");
            tickerflipper.attach(&errorBlink, 0.3);
            led1=false;
        return;
        }
        if (checker() == true)
        {
            status = ST_ON;
            removeTime.detach();
            return;
        }

    }
}