#include "mbed.h"

#define UP 1
#define DOWN 2
#define STOP 0

InterruptIn iiCenter(p14);  
InterruptIn iiDown(p12);
InterruptIn iiUp(p15);
InterruptIn iiLeft(p13);
InterruptIn iiRight(p16);
BusOut doLeds(LED1,LED2,LED3,LED4);
float delay = 0.5;   
char countDown = STOP;

void swOff() {
    doLeds = 0; 
    countDown = STOP;    
}
void slow() {
    delay = 0.5;       
}
void fast() {
    delay = 0.25;   
}
void cUp() {
    countDown = UP;    
}
void cDown() {
    countDown = DOWN;    
}

int main()
{
    doLeds = 0;
    iiCenter.rise(&swOff);
    iiLeft.rise(&slow);
    iiRight.fall(&fast);
    iiDown.rise(&cDown);
    iiUp.rise(&cUp);
    
    while(1) {
        if (countDown == DOWN)
            doLeds = doLeds -1;
        else if (countDown == UP)
            doLeds = doLeds +1;
    
        wait(delay);
    }
}
