/*
 * WS2812 tape led IC
 */
#include "mbed.h"
#include "LEDStrip.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

// Data = Green = Mosi = P11
// White = Black = GND
// Red = 5V

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    exit(-1);
}

int main() {
    int j, k = 0;

    pc.baud(115200);
    tapeInit(0, 32);
    led1 = 1;

    pc.printf("led\r\n");
    
    led1 = 0; led2 = 1;
    int i = 0;
    int d = 1;
    for (;;) {
        i += d;
        if(i == 256)
            d = -1;
        if(i == 0)
            d = 1;
        led1 = i & 1;
        led2 = (i >> 1) & 1;
        led3 = (i >> 2) & 1;
        led4 = (i >> 3) & 1;
        for(int j=0; j<32;j++){
          int val = j * 8 + i + (j * 256*256);
          
          tapeSet(j, val);
        }
        tapeSend();
        wait_ms(100);
    }
}
