; MSEl=6, PSEL=1, DIV=3 ==> 28MHz


RAMForIAP       EQU 128
RomSize         EQU 0x4000
    
;-----------------------------------
; This is the specific file for 
; LPC8xx chip
; to be used with forth main program
;-----------------------------------
APB             EQU 0x40000000
PINASSIGN0      EQU 0x4000C000
SYSAHBCLKCTRL   EQU 0x40048080
UARTCLKDIV      EQU 0x40048094
USART0          EQU 0x40064000
CFG             EQU 0x000 
CTL             EQU 0x004 
STAT            EQU 0x008 
INTENSET        EQU 0x00C 
INTENCLR        EQU 0x010 
RXDAT           EQU 0x014 
TXDAT           EQU 0x01C 
BRG             EQU 0x020 
INTSTAT         EQU 0x024
PIO0_1          EQU 1
PIO0_6          EQU 6
RX              EQU PIO0_1
TX              EQU PIO0_6

;/*****************************************************************************
; * @file:    startup_LPC8xx.s
; * @purpose: CMSIS Cortex-M0+ Core Device Startup File
; *           for the NXP LPC8xx Device Series
; * @version: V1.0
; * @date:    16. Aug. 2012
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; * Copyright (C) 2012 ARM Limited. All rights reserved.
; * ARM Limited (ARM) is supplying this software for use with Cortex-M0+
; * processor based microcontrollers.  This file can be freely distributed
; * within development tools that are supporting such ARM based processors.
; *
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; *****************************************************************************/
; Vector Table Mapped to Address 0 at Reset
                THUMB
                AREA    RESET, DATA , READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     SPI0_IRQHandler             ; SPI0 controller
                DCD     SPI1_IRQHandler             ; SPI1 controller
                DCD     0                           ; Reserved
                DCD     UART0_IRQHandler            ; UART0
                DCD     UART1_IRQHandler            ; UART1
                DCD     UART2_IRQHandler            ; UART2
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     I2C_IRQHandler              ; I2C controller
                DCD     SCT_IRQHandler              ; Smart Counter Timer
                DCD     MRT_IRQHandler              ; Multi-Rate Timer
                DCD     CMP_IRQHandler              ; Comparator
                DCD     WDT_IRQHandler              ; PIO1 (0:11)
                DCD     BOD_IRQHandler              ; Brown Out Detect
                DCD     0                           ; Reserved
                DCD     WKT_IRQHandler              ; Wakeup timer
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     0                           ; Reserved
                DCD     PININT0_IRQHandler          ; PIO INT0
                DCD     PININT1_IRQHandler          ; PIO INT1
                DCD     PININT2_IRQHandler          ; PIO INT2
                DCD     PININT3_IRQHandler          ; PIO INT3
                DCD     PININT4_IRQHandler          ; PIO INT4
                DCD     PININT5_IRQHandler          ; PIO INT5
                DCD     PININT6_IRQHandler          ; PIO INT6
                DCD     PININT7_IRQHandler          ; PIO INT7

                IF      :LNOT::DEF:NO_CRP
                AREA    |.ARM.__at_0x02FC|, CODE
                    ; , READONLY
CRP_Key         DCD     0xFFFFFFFF
                ENDIF

                AREA    |.text|, CODE
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  NMI_Handler               [WEAK]
                EXPORT  SPI0_IRQHandler           [WEAK]
                EXPORT  SPI1_IRQHandler           [WEAK]
                EXPORT  UART0_IRQHandler          [WEAK]
                EXPORT  UART1_IRQHandler          [WEAK]
                EXPORT  UART2_IRQHandler          [WEAK]
                EXPORT  I2C_IRQHandler            [WEAK]
                EXPORT  SCT_IRQHandler            [WEAK]
                EXPORT  MRT_IRQHandler            [WEAK]
                EXPORT  CMP_IRQHandler            [WEAK]
                EXPORT  WDT_IRQHandler            [WEAK]
                EXPORT  BOD_IRQHandler            [WEAK]
                EXPORT  WKT_IRQHandler            [WEAK]
                EXPORT  PININT0_IRQHandler      [WEAK]
                EXPORT  PININT1_IRQHandler      [WEAK]
                EXPORT  PININT2_IRQHandler      [WEAK]
                EXPORT  PININT3_IRQHandler      [WEAK]
                EXPORT  PININT4_IRQHandler      [WEAK]
                EXPORT  PININT5_IRQHandler      [WEAK]
                EXPORT  PININT6_IRQHandler      [WEAK]
                EXPORT  PININT7_IRQHandler      [WEAK]

NMI_Handler
SPI0_IRQHandler
SPI1_IRQHandler
UART0_IRQHandler
UART1_IRQHandler
UART2_IRQHandler
I2C_IRQHandler
SCT_IRQHandler
MRT_IRQHandler
CMP_IRQHandler
WDT_IRQHandler
BOD_IRQHandler
WKT_IRQHandler
PININT0_IRQHandler
PININT1_IRQHandler
PININT2_IRQHandler
PININT3_IRQHandler
PININT4_IRQHandler
PININT5_IRQHandler
PININT6_IRQHandler
PININT7_IRQHandler

                B       .

                ENDP
                ALIGN
;       Configure USART 0/1/2 for receiving and transmitting data:
;       In the SYSAHBCLKCTRL register, set bit 14 to 16 (Table 18) to enable the clock to the register interface.


; FLASHCFG et FLASHTIM >> à seter to 0 !!!!!!!!!

UartConfig
        MOVS    r2, #1
        LSLS    r2, #14             ; USART0 (bit 14)
        LDR     r1, =SYSAHBCLKCTRL
        LDR     r0, [r1]
        ORRS    r0, r0, r2
        STR     r0, [r1]
;Configure the USART0 pin functions through the switch matrix. See Section 15.4.
Value   EQU     TX+256*(RX+(256*(255+256*255)))
        LDR     r0,=Value
        LDR     r1,=PINASSIGN0
        STR     r0,[r1]
;Configure the UART clock div
        MOVS    r0,#3               ; UART clock 4MHz/16
        LDR     r1,=UARTCLKDIV
        STR     r0,[r1]
        LDR     r1,=(USART0)
;Configure data
        MOVS    r0,#0x05            ; 8 bits, no Parity, 1 Stop bit */
        STR     r0, [r1,#CFG]
;Configure BRG
        MOVS    r0,#12              ; 19200bps
;       MOVS    r0,#3               ; 57600bps
        STR     r0,[r1,#BRG]
        BX      lr
        LTORG
;-----------------------------------
; DONT Change the 3 lines below
; and leave the xEmit label on 
; the same line as instruction
;-----------------------------------
LTx     LINK    LDup
        DCB     4
        DCB     "EMIT"
    
;-----------------------------------
; Place here your code for the Emit
; routine 
; If it is a high level put a doCol
; at the beginning and an Exit at the end
;-----------------------------------
Emit    DCD     xEmit
xEmit   LDR     r1,=(USART0)
Emit1   LDR     r2,[r1,#STAT]
        LSRS    r2,#3
        BCC     Emit1               ; ? ready to Xmit
        STR     TOS,[r1,#TXDAT]     ; Xmit
        POP     {TOS}               ; Discard & Update TOS 
        Next

;-----------------------------------
; DONT Change the 4 lines below
; and leave the xRecv label on 
; the same line as instruction
;-----------------------------------
LRecv   LINK    LTx 
        DCB     4
        DCB     "KEY?"
KeyQ    DCD     Recv0
;-----------------------------------
; Place here your code for the Key?
; routine 
; If it is a high level put a doCol
; at the beginning and an Exit at the end
;-----------------------------------

Recv0   PUSH    {TOS}
        LDR     r1,=(USART0)
        LDR     r2,[r1,#STAT]
        LSRS    r2,#1
        BCC     Recv1
        LDR     TOS,=0xffffffff     ; True flag
        B       Recv2
Recv1   SUBS    TOS,TOS             ; Clear TOS (false falg)
Recv2   Next

;-----------------------------------
; DONT Change the 4 lines below
;-----------------------------------
LKey    LINK    LRecv
        DCB     3
        DCB     "KEY"
Key     DCD     xKey
;-----------------------------------
; Place here your code for the Key
; routine 
; If it is a high level put a doCol
; at the begenning and an Exit at the end
;-----------------------------------
xKey    PUSH    {TOS}
        LDR     r1,=(USART0)
Key1    LDR     r2,[r1,#STAT]
        LSRS    r2,#1
        BCC     Key1
        LDR     TOS,[r1,#RXDAT]
        Next
        END