//Currentl a hand held smart assive secuirty and mulitple function tool.
//Has the ability to active alarm and LEDs if anyone unautherised try to access it
//Also capabile of manually actiaving the alarm, Flash the LEDs and changing the
//LCD screen brightness, with more options to be added later.

//Issues - Current error of not compilying otherwhise it is compeleted

//Libraries
#include "mbed.h" 
#include "GT511C3.hpp"
#include "N5110.h"
#include "Joystick.h"
#include "beep.h"

//Ports
Serial   PC(USBTX, USBRX); //Serial Connection
GT511C3  finger(PTC17,PTC16);//Fingerprint scanner Connection
N5110    lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); // LCD screen Connection
Joystick joystick(PTB10,PTB11,PTC16); // Joystick Connection


AnalogIn  mypot(PTB2); //Potentiometer on gamepad
Beep      pz(PTC10);   //Piezo on gamepad
DigitalIn start(PTC5); //Start button on gamepad
DigitalIn back(PTB19); //Back button on gamepad


DigitalIn A(PTB9); //Buttons A, B, X amd Y
DigitalIn B(PTD0);
DigitalIn X(PTC17);
DigitalIn Y(PTC12);

DigitalOut myled(LED1); //LED on K64
DigitalOut led1(PTA1); //LED's 1-6 on gamepad
DigitalOut led2(PTA2);
DigitalOut led3(PTC2);
DigitalOut led4(PTC3);
DigitalOut led5(PTC4);
DigitalOut led6(PTD3);

//Functions
void initization();
void test_ports();
void startscreen();
void login();
void alarm();
void led();
void lcdrightness();
void piezohz();
void alarmtime();
void newenroll();
void menu();
void navigator();
void submenu1();
void submenu2();
void sleep();

//Variables
char buffer[14];
float pot_value = 0.5;
float hz_value = 1000;
int time_value = 10;
int sts = 0;
int ID = 0;

int progress(int status,char *msg){//tracking progress
    PC.printf("%s", msg);
    return 0;
}

void initization(){

    PC.format(8,Serial::None,1);
    PC.baud(9600);

    PC.printf("Fingerprint reader module \"GT-511C3\" test program. \n");
    PC.printf("Build: %s %s \n",__DATE__,__TIME__);

    sts = finger.Open();
    PC.printf("sts = %d \n",sts);
    if(sts == 0){
        int i;
        PC.printf("FirmwareVersion = %lx \n",finger.FirmwareVersion);
        PC.printf("IsoAreaMaxSize = %ld \n",finger.IsoAreaMaxSize);
        PC.printf("DeviceSerialNumber = %ld \n", finger.DeviceSerialNumber);
        for(i = 0; i < sizeof(finger.DeviceSerialNumber); i++) {
            PC.printf("%02X",finger.DeviceSerialNumber[i]);
        } //prints information about the system
    }
    PC.printf("\n");

    lcd.init(); //initiliaze lcd
    lcd.normalMode();
    lcd.setBrightness(0.5);
    lcd.setContrast(0.5);

    joystick.init(); //initiliaze joystick

    A.mode(PullDown); //Set buttons so, pressed = high and not pressed = low
    B.mode(PullDown);
    X.mode(PullDown);
    Y.mode(PullDown);
    start.mode(PullDown);
    back.mode(PullDown);

    test_ports(); //test connections
}

void test_ports(){
    PC.printf("test \n");

    //check each button, LEDs and print character on screen
    if(A.read() == 1){
        lcd.clear();
        lcd.printString("Print A",0,1);
        lcd.refresh();
        PC.printf("Button A Pressed \n");
        led1 = 1; led2 = 1; wait(2);
        led1 = 0; led2 = 0;
    }

    if(B.read() == 1){
        lcd.clear();
        lcd.printString("Print B",0,1);
        lcd.refresh();
        PC.printf("Button B Pressed \n");
        led3 = 1; led4 = 1; wait(2);
        led3 = 0; led4 = 0;
    }

    if(Y.read() == 1){
        lcd.clear();
        lcd.printString("Print Y",0,1);
        lcd.refresh();
        PC.printf("Button Y Pressed \n");
        led5 = 1; led6 = 1; wait(2);
        led5 = 0; led6 = 0;
    }

    if(X.read() == 1){
        lcd.clear();
        lcd.printString("Print X",0,1);
        lcd.refresh();
        PC.printf("Button X Pressed \n");
        led1 = 1; led2 = 1; led3 = 1;
        led4 = 1; led5 = 1; led6 = 1; wait(2);
        led1 = 0; led2 = 0; led3 = 0;
        led4 = 0; led5 = 0; led6 = 0;
    }

    pot_value = mypot.read(); //range between 0.0 - 1.0
    hz_value = 10000*pot_value; // converts pot value to between 1000hz to 10000hz

    PC.printf("Pot value = %.2f \n",pot_value);
    PC.printf("Hz value = %.2f \n",hz_value);

    lcd.clear();
    lcd.setContrast(pot_value); //tune LCD contrast
    lcd.setBrightness(pot_value); //tune LCD brightness
    lcd.refresh();

    if(start.read() == 1){
        startscreen();
    }
}

void startscreen(){
    PC.printf("Ideal \n");
    
    lcd.clear();
    lcd.printString("--Idle State--", 0,0);
    lcd.printString("To Begin",    0,1);
    lcd.printString("Press Start", 0,2);
    lcd.refresh();
    int f = 0;
    
    while(start.read() != 1){
        sleep();
    }
    
    if(start.read() == 1){ //when Start button pressed activate
        PC.printf("Start \n");
        int EnrollID = 11; // Correct Finger Enroll number
        if(finger.CheckEnrolled(EnrollID) == 0){
            PC.printf("EnrollID(%d) is already enrolled. Delete! \n",EnrollID);
            if(finger.DeleteID(EnrollID) == 0){
                PC.printf("Delete OK! \n");
            }
        }

        lcd.clear(); //prompt user
        lcd.printString("Hello, Please", 0,0);
        lcd.printString("Place Finger" , 0,1);
        lcd.printString("on the Scanner",0,2);
        lcd.printString("to Verify ID!", 0,3);
        lcd.refresh();
        wait(5.0);

        lcd.clear();
        lcd.printString("This will",0,0);
        lcd.printString("require three",0,1);
        lcd.printString("attemps of the",0,2);
        lcd.printString("desired finger",0,3);
        lcd.printString("to enroll!",0,4);
        lcd.refresh();

        finger.Enroll(EnrollID,progress);//Enrollment

        if(finger.CheckEnrolled(EnrollID) == 0){//Enrollment completed
            lcd.clear();
            lcd.printString("Fingerprint",0,0);
            lcd.printString("Accepted",0,1);
            lcd.refresh();
            f = 1;
            wait(2.0);
        }
    }
    finger.CmosLed(1);
    if(f == 1){
        login();
        f = 0;
    }
}

void login(){
    PC.printf("Login \n");

    lcd.clear();
    lcd.printString("Scan finger",0,0);
    lcd.printString("to login",0,1);
    lcd.refresh();
    finger.WaitPress(1);
    if(finger.Capture(1) != 0){
        ID = finger.Identify();
        PC.printf("ID = %d \n",ID);
        if(ID == 11){    //check if user has valid finger print
            lcd.clear(); //if correct, access menu
            lcd.printString("Access granted",0,0);
            lcd.printString("Welcome! Aaron",0,1);
            lcd.refresh();
            PC.printf("Access granted \n");
            wait(2.0);
            menu(); //go to menu
        }

        if(ID == -1){ //failed to validate
            lcd.clear();
            lcd.printString("Unautherised",0,0);
            lcd.printString("Please try",0,1);
            lcd.printString("again",0,1);
            lcd.refresh();
            wait(2.0);
            int reset;
            reset++;
            if(reset == 3){ //three failed attpts locks the system
                lcd.clear();
                lcd.printString("Three failed ",0,0);
                lcd.printString("attempts, ",0,1);
                lcd.printString("locking system",0,2);
                lcd.printString("for 30 seconds",0,3);
                lcd.refresh();
                PC.printf("Locking system \n");
                alarm();
                wait(20.0);
                PC.printf("Unlocking system \n");
                reset = 0;
                startscreen();
            }
        }
        PC.printf("Remove finger \n");
        finger.WaitPress(0);
    }
}

void alarm(){
    PC.printf("Alarm \n");
    
    int l = 0;
    int hz = hz_value;
    int time = time_value;
    pz.beep(hz,time); //pizeo goes off for set time amount

    if(l <= 5){    // LED's flashing for 5 cycles
        led1 = 1; wait(0.33); led1 = 0;
        led2 = 1; wait(0.33); led2 = 0;
        led3 = 1; wait(0.33); led3 = 0;
        led4 = 1; wait(0.33); led4 = 0;
        led5 = 1; wait(0.33); led5 = 0;
        led6 = 1; wait(0.33); led6 = 0;
        PC.printf("led loop %d \n",l);
        l++;
    }
}

void led(){
    PC.printf("led settings \n");
    int count = 0;

    lcd.clear();
    lcd.printString("Levels: 0 - 6",0,0);   //Possiable levels
    lcd.printString("Press A to +1",0,1);
    lcd.printString("Press B to -1",0,2);
    lcd.printString("Back",0,3);
    lcd.refresh();
    PC.printf("led level %d \n",count);
    if(A.read() == 1){
        count++;
        lcd.refresh();
    }
    if(B.read() == 1){
        count--;
        lcd.refresh();
    }
    if(count == 0){
        led1 = 0; led2 = 0; led3 = 0;
        led4 = 0; led5 = 0; led6 = 0;
    }
    if(count == 1){
        led1 = 1; led2 = 0; led3 = 0;
        led4 = 0; led5 = 0; led6 = 0;
    }
    if(count == 2){
        led1 = 1; led2 = 1; led3 = 0;
        led4 = 0; led5 = 0; led6 = 0;
    }
    if(count == 3){
        led1 = 1; led2 = 1; led3 = 1;
        led4 = 0; led5 = 0; led6 = 0;
    }
    if(count == 4){
        led1 = 1; led2 = 1; led3 = 1;
        led4 = 1; led5 = 0; led6 = 0;
    }
    if(count == 5){
        led1 = 1; led2 = 1; led3 = 1;
        led4 = 1; led5 = 1; led6 = 0;
    }
    if(count == 6){
        led1 = 1; led2 = 1; led3 = 1;
        led4 = 1; led5 = 1; led6 = 1;
    }

    if(back.read() == 1){
        menu();
    }
}

void lcdbrightness(){
    PC.printf("lcd brightness \n");
    
    lcd.clear();
    lcd.printString("----LCD----",0,0);// change brightness and contrast using pot
    lcd.printString("Range: 0 - 1",0,1);
    lcd.printString("Use Pot to",0,2);
    lcd.printString("change level",0,3);
    lcd.refresh();

    if(pot_value != mypot.read()){
        pot_value = mypot.read();
        lcd.setBrightness(pot_value);
        lcd.setContrast(pot_value);
        lcd.refresh();
    }

    if(back.read() == 1){
        menu();
    }
}

void piezohz(){
    PC.printf("piezo hz \n");
    
    lcd.clear();
    lcd.printString("--Piezo Khz--",0,0);// change frequency level of pizeo
    lcd.printString("Range: 1 - 10",0,1);
    lcd.printString("Use Pot to",0,2);
    lcd.printString("change level",0,3);
    lcd.refresh();
    hz_value = 10000*pot_value; // converts pot value to between 1000hz to 10000hz
    if(hz_value != (10000*mypot.read())){
        hz_value = (10000*mypot.read());
    }
    if(back.read() == 1){
        menu();
    }
}

void alarmtime(){
    PC.printf("alarm time \n"); //set alarm time
    
    int count = 0;
    lcd.clear();
    lcd.printString("Alarm length",0,0);
    sprintf(buffer,"Time = %2d s",count);
    lcd.printString(buffer,0,1); 
    lcd.printString("Press A to +1",0,2);
    lcd.printString("Press B to -1",0,3);
    lcd.refresh();
    PC.printf("led level %d \n",count);

    if(A.read() == 1){
        count++;
        lcd.refresh();
    }
    if(B.read() == 1){
        count--;
        lcd.refresh();
    }
    if(time_value != count){
        time_value = count;
    }
    if(back.read() == 1){
        menu();
    }
}

void newenroll(){
    int f = 0;

    lcd.clear();
    lcd.printString("Scan finger",0,0);
    lcd.printString("to login",0,1);
    lcd.refresh();
    finger.WaitPress(1);
    if(finger.Capture(1) != 0){
        ID = finger.Identify();
        PC.printf("ID = %d \n",ID);
        if(ID == 11){    //check if user has valid finger print
            lcd.clear(); //if correct, access menu
            lcd.printString("Access granted",0,0);
            lcd.printString("Welcome! Aaron",0,1);
            lcd.refresh();
            PC.printf("Access granted \n");
            wait(2.0);
            
    PC.printf("Enrolling \n");// scan new finger
    lcd.clear();
    lcd.printString("--New Enroll--", 0,0);
    lcd.printString("Press start",    0,1);
    lcd.printString("to begin.", 0,2);
    lcd.refresh();
    

    if(start.read() == 1){ //when Start button pressed activate
        PC.printf("Start \n");
        int EnrollID = 11; // Correct Finger Enroll number
        if(finger.CheckEnrolled(EnrollID) == 0){
            PC.printf("EnrollID(%d) is already enrolled. Delete! \n",EnrollID);
            if(finger.DeleteID(EnrollID) == 0){
                PC.printf("Delete OK! \n");
            }
        }

        lcd.clear(); //prompt user
        lcd.printString("Hello, Please", 0,0);
        lcd.printString("Place Finger" , 0,1);
        lcd.printString("on the Scanner",0,2);
        lcd.printString("to Verify ID!", 0,3);
        lcd.refresh();
        wait(5.0);

        lcd.clear();
        lcd.printString("This will",0,0);
        lcd.printString("require three",0,1);
        lcd.printString("attemps of the",0,2);
        lcd.printString("desired finger",0,3);
        lcd.printString("to enroll!",0,4);
        lcd.refresh();

        finger.Enroll(EnrollID,progress);//Enrollment

        if(finger.CheckEnrolled(EnrollID) == 0){//Enrollment completed
            lcd.clear();
            lcd.printString("Fingerprint",0,0);
            lcd.printString("Accepted",0,1);
            lcd.refresh();
            f = 1;
            PC.printf("Enrolled \n");
            wait(2.0);
        }
    }
    }
    }
    finger.CmosLed(1);
    if(f == 1){
        login();
        f = 0;
    }
}

void menu(){

    lcd.clear();
    lcd.printString("--Main Menu--",0,0);//Menu, currently having the ability to
    lcd.printString("Alarm",0,1);     //Active alarm
    lcd.printString("LED Lights",0,2);//Turn on the LED's
    lcd.printString("Settings",0,3); //Change propteies
    lcd.refresh();
    PC.printf("Menu \n");
    navigator();
    int y;

    while(A == 1){
    if(y == 1){
        alarm();
        menu();
    }
    if(y == 2){
        led();
    }
    if(y == 3){
        submenu1();
    }
    }
}

void submenu1(){

    lcd.clear();
    lcd.printString("--Settings--",0,0);
    lcd.printString("LCD Brightness",0,1);//Go to LCD settings
    lcd.printString("Piezo Hz",0,2);    //Go to Piezo settings
    lcd.printString("More Settings",0,3); //Next subMenu
    
    PC.printf("Submenu1 \n");
    
    navigator();
    int y;

    while(A == 1){
    if(y == 1){
        lcdbrightness();
    }
    if(y == 2){
        piezohz();
    }
    if(y == 3){
        submenu2();
    }

    if(back.read() == 1){
        menu();
    }
    }
}

void submenu2(){

    lcd.clear();
    lcd.printString("--Return--",0,0);//Return to Menu
    lcd.printString("Alarm Time",0,1);//Change alarm time
    lcd.printString("New Enrol",0,2);//New scan for fingerprint
    lcd.printString("Go Ideal",0,3); //Sleep
    
    PC.printf("Submenu2 \n");
    
    navigator();
    int y;

    if(back.read() == 1){
        submenu1();
    }
    while(A == 1){
    if(y == 1){
        alarmtime();
    }
    if(y == 2){
        newenroll();
    }

    if(back == 1){
        startscreen();
    }
    if(back.read() == 1){
        menu();
    }
    }
}

void navigator(){
    
     int y;

     Direction d = joystick.get_direction();//navigators the menu using joystick
     PC.printf("Direction = %i \n",d);
     lcd.printString(">",0,y);
     lcd.refresh();

     if(d == 1){
     y++;
     lcd.printString(">",0,y);
     wait(0.2);
     lcd.refresh();
     }
     else if(d == 5){
     y--;
     lcd.printString(">",0,y);
     wait(0.2);
     lcd.refresh();
     }
}

