#ifndef SPIENCODER_H_
#define SPIENCODER_H_

#include "mbed.h"

#ifdef __cplusplus
extern "C" {
#endif

SPI EncoderSpi(p5, p6, p7);//Mosi Miso Sclk
DigitalOut cs(p8); //Chip select
DigitalOut cs1(p9); //Chip select

uint16_t EncoderByteData = 0;
uint16_t Encoderposition_last = 0;
uint8_t temp[2];
uint16_t Steps;

uint16_t EncoderByteData1 = 0;
uint16_t Encoderposition_last1 = 0;
uint8_t temp1[2];
uint16_t Steps1;

void wait_ms(int us);

void InitializeEncoder()
{
    EncoderSpi.format(8,0);
    EncoderSpi.frequency(8000000);
}
//------------------------------------------EncoderA---------------------------------------------------
uint8_t SPI_T (uint8_t SPITransmit)//Repetive SPI transmit sequence
{
    uint8_t SPI_temp = 0;  //vairable to hold recieved data
    cs=0;     //select spi device
    SPI_temp = EncoderSpi.write(SPITransmit);//send and recieve
    cs=1;//deselect spi device
    return(SPI_temp);      //return recieved byte
}

void start()
{
    uint8_t recieved = 0xA5;//just a temp vairable
    EncoderByteData  = 0;//reset position vairable
    cs=0;
    SPI_T(0x10);//issue read command
    wait_ms(50);//give time to read. Timmig is critical

    while (recieved != 0x10) { //loop while encoder is not ready to send
        recieved = SPI_T(0x00); //cleck again if encoder is still working
        wait_ms(1); //again,give time to read. Timmig is critical
    }

    temp[0] = SPI_T(0x00); //Recieve MSB
    temp[1] = SPI_T(0x00); // recieve LSB
    cs=1;

    temp[0] &=~ 0xF0;//mask out the first 4 bits
    EncoderByteData  = temp[0] << 8; //shift MSB to correct EncoderByteData in EncoderByteData message
    EncoderByteData  += temp[1]; // add LSB to EncoderByteData message to complete message
    wait_ms(1);//again,give time to read. Timmig is critical
}


void EncoderA()
{
    if (EncoderByteData != Encoderposition_last) { //if nothing has changed dont wast time sending position
        Encoderposition_last = EncoderByteData ; //set last position to current position
    } else {
        start();   //if something has changed in position, catch it
    }
    Steps = EncoderByteData/16;
}
//-----------------------------------------------EncoderB---------------------------------------------------------------
uint8_t SPI_TT (uint8_t SPITransmit1)//Repetive SPI transmit sequence
{
    uint8_t SPI_temp1 = 0;  //vairable to hold recieved data
    cs1=0;     //select spi device
    SPI_temp1 = EncoderSpi.write(SPITransmit1);//send and recieve
    cs1=1;//deselect spi device
    return(SPI_temp1);      //return recieved byte
}

void start1()
{
    uint8_t recieved1 = 0xA5;//just a temp vairable
    EncoderByteData1  = 0;//reset position vairable
    cs1=0;
    SPI_TT(0x10);//issue read command
    wait_ms(50);//give time to read. Timmig is critical

    while (recieved1 != 0x10) { //loop while encoder is not ready to send
        recieved1 = SPI_TT(0x00); //cleck again if encoder is still working
        wait_ms(1); //again,give time to read. Timmig is critical
    }

    temp1[0] = SPI_TT(0x00); //Recieve MSB
    temp1[1] = SPI_TT(0x00); // recieve LSB
    cs1=1;

    temp1[0] &=~ 0xF0;//mask out the first 4 bits
    EncoderByteData1  = temp1[0] << 8; //shift MSB to correct EncoderByteData in EncoderByteData message
    EncoderByteData1  += temp1[1]; // add LSB to EncoderByteData message to complete message
    wait_ms(1);//again,give time to read. Timmig is critical
}
void EncoderB()
{
    if (EncoderByteData1 != Encoderposition_last1) { //if nothing has changed dont wast time sending position
        Encoderposition_last1 = EncoderByteData1 ; //set last position to current position
    } else {
        start1(); //if something has changed in position, catch it
    }
    Steps1 = EncoderByteData1/16;
}

#ifdef __cplusplus
}
#endif

#endif // #ifndef SPIENCODER_H_