#ifndef GPSUAV_H_
#define GPSUAV_H_

#include "mbed.h"

#ifdef __cplusplus
extern "C" {
#endif

Serial gps(p28, p27);  // TX, RX GPS
Serial pc(USBTX, USBRX);// TX, RX
char s[85];
char y1,y2,y3,y4,y5,y6,y7,y8,y9;
char x1,x2,x3,x4,x5,x6,x7,x8,x9,x10;
char NS,WE;
char GPSBuffer[85];
char Latitude[10];
char Longitude[11];

char spd1,spd2,spd3,spd4,spd5,spd6,spd7;
char speed[8];
float speedInt;

char hdg1,hdg2,hdg3,hdg4,hdg5;
char HDG[5];
char Heading[6];
float HeadingInt;

char GpsFix[2];
char GF;
int GFInt;
char NOS[3];
char Nos1,Nos2;
int NOSInt;
char HDOP[6];
char Hdp1,Hdp2,Hdp3,Hdp4,Hdp5;
float HDOPInt;

char LatDeg[3];
char LatMin[8];
int LatDegInt;
float LatMinInt;

char LongDeg[4];
char LongMin[8];
int LongDegInt;
float LongMinInt;
void wait_ms(int us);

void EnableGPS()
{
        pc.baud(9600); 
        GPSBuffer[0] = '\0';
        while (1) {
            char c = gps.getc();         
            s[0] = c;
            s[1] = '\0';
            strcat(GPSBuffer, s);
            if (c == '\n') {
                break;
            }
  if ((GPSBuffer[1] == 'G') && (GPSBuffer[2] == 'N') && (GPSBuffer[3] == 'R') && (GPSBuffer[4] == 'M') && (GPSBuffer[5] == 'C')&& (GPSBuffer[17] == 'A'))
  { // $GNRMC,174216.00,A,3908.86289,N,07647.84392,W,2.419,237.21,210219,,,A*6E
     
    //Latitude---------------------------------------------------------------------------------------------------------------
    y1= GPSBuffer[19]; y2 = GPSBuffer[20]; //Degrees
    y3= GPSBuffer[21]; y4 = GPSBuffer[22];y5= GPSBuffer[24]; y6 = GPSBuffer[25];y7= GPSBuffer[26]; y8 = GPSBuffer[27];y9= GPSBuffer[28]; //DEGMIN
    NS = GPSBuffer[30];
    
    sprintf(LatDeg,"%c%c",y1,y2);
    sprintf(LatMin,"%c%c%c%c%c%c%c",y3,y4,y5,y6,y7,y8,y9);
    
    LatDegInt = atoi(LatDeg);
    LatMinInt = atoi(LatMin);
    LatMinInt = LatMinInt/100000;
  //---------------------------------------------------------------- 
    //Longitude 
    x1= GPSBuffer[32]; x2= GPSBuffer[33]; x3= GPSBuffer[34];//Degrees
    x4=GPSBuffer[35]; x5=GPSBuffer[36]; x6=GPSBuffer[38]; x7=GPSBuffer[39]; x8=GPSBuffer[40]; x9=GPSBuffer[41];x10=GPSBuffer[42];//DEGMIN
    WE=GPSBuffer[44];
       
    sprintf(LongDeg,"%c%c%c",x1,x2,x3);
    sprintf(LongMin,"%c%c%c%c%c%c%c",x4,x5,x6,x7,x8,x9,x10);
    
    LongDegInt = atoi(LongDeg);
    LongMinInt = atoi(LongMin);
    LongMinInt = LongMinInt/100000;
               
 //--------------------------------------------get speed------------------------------------------------------------------
  if((GPSBuffer[47] == '.')&& (GPSBuffer[51] == ','))//2.419
   {
    spd1=GPSBuffer[46]; spd2=GPSBuffer[47]; spd3=GPSBuffer[48]; spd4=GPSBuffer[49]; spd5=GPSBuffer[50];      
    sprintf(speed,"00%c%c%c%c%c",spd1,spd2,spd3,spd4,spd5);     
   }   
  if((GPSBuffer[48] == '.')&& (GPSBuffer[52] == ','))//24.191
   {
    spd1=GPSBuffer[46]; spd2=GPSBuffer[47]; spd3=GPSBuffer[48]; spd4=GPSBuffer[49]; spd5=GPSBuffer[50]; spd6=GPSBuffer[51];      
    sprintf(speed,"0%c%c%c%c%c%c",spd1,spd2,spd3,spd4,spd5,spd6);     
   }
  if((GPSBuffer[49] == '.')&& (GPSBuffer[53] == ','))//240.191
   {
    spd1=GPSBuffer[46]; spd2=GPSBuffer[47]; spd3=GPSBuffer[48]; spd4=GPSBuffer[49]; spd5=GPSBuffer[50]; spd6=GPSBuffer[51]; spd7=GPSBuffer[52];    
    sprintf(speed,"%c%c%c%c%c%c%c",spd1,spd2,spd3,spd4,spd5,spd6,spd7);     
   }
    speedInt = atof(speed); //speed in knots
 
//----------------------------------------get Heading-------------------------------------------------------------------
 }
 if ((GPSBuffer[1] == 'G') && (GPSBuffer[2] == 'N') && (GPSBuffer[3] == 'V')&& (GPSBuffer[4] == 'T')&& (GPSBuffer[5] == 'G'))//MC Sentence
{
   
   if((GPSBuffer[8] == '.')&& (GPSBuffer[10] == ','))//2.4
   {
    hdg1=GPSBuffer[7]; hdg2=GPSBuffer[8]; hdg3=GPSBuffer[9];  
    sprintf(Heading,"00%c%c%c",hdg1,hdg2,hdg3);     
   }
    if((GPSBuffer[9] == '.')&& (GPSBuffer[11] == ','))//20.4
   {
    hdg1=GPSBuffer[7]; hdg2=GPSBuffer[8]; hdg3=GPSBuffer[9]; hdg4=GPSBuffer[10];    
    sprintf(Heading,"0%c%c%c%c",hdg1,hdg2,hdg3,hdg4);     
   }
   if((GPSBuffer[10] == '.')&&(GPSBuffer[12] == ','))//200.4
   {
    hdg1=GPSBuffer[7]; hdg2=GPSBuffer[8]; hdg3=GPSBuffer[9]; hdg4=GPSBuffer[10]; hdg5=GPSBuffer[11];  
    sprintf(Heading,"%c%c%c%c%c",hdg1,hdg2,hdg3,hdg4,hdg5);     
   }
    HeadingInt=atof(Heading);
}
if ((GPSBuffer[1] == 'G') && (GPSBuffer[2] == 'N') && (GPSBuffer[3] == 'G')&& (GPSBuffer[4] == 'G')&& (GPSBuffer[5] == 'A'))//MC Sentence
{  //$GNGGA,193247.00,3908.85437,N,07647.82746,W,1,11,0.86,50.0,M,-34.7,M,,*4E start at 44
 
     GF=GPSBuffer[44];
     sprintf(GpsFix,"%c",GF);
     GFInt = atoi(GpsFix);//gpsfix
     
     Nos1=GPSBuffer[46];
     Nos2=GPSBuffer[47];
     sprintf(NOS,"%c%c",Nos1,Nos2);//number of sats
     NOSInt = atoi(NOS);
         
    if((GPSBuffer[50] == '.')&& (GPSBuffer[53] == ','))//0.66
   {
      Hdp1=GPSBuffer[49]; Hdp2=GPSBuffer[50]; Hdp3=GPSBuffer[51]; Hdp4=GPSBuffer[52]; 
      sprintf(HDOP,"0%c%c%c%c", Hdp1,Hdp2,Hdp3,Hdp4);  
   }
    if((GPSBuffer[51] == '.')&& (GPSBuffer[54] == ','))//00.66
   {
      Hdp1=GPSBuffer[49]; Hdp2=GPSBuffer[50]; Hdp3=GPSBuffer[51]; Hdp4=GPSBuffer[52];Hdp5=GPSBuffer[53];
      sprintf(HDOP,"%c%c%c%c%c",Hdp1,Hdp2,Hdp3,Hdp4,Hdp5);  
   }
     HDOPInt = atof(HDOP);//hdop
}  
}
}

#ifdef __cplusplus
}
#endif

#endif // #ifndef GPSUAV_H_