#include "mbed.h"
#include "DHT.h"



#define DHT_TIPO        DHT11
#define DHT_PIN         PTA13

//Definicion de objjeto del sensor de humedad y temperatura
DHT dht(DHT_PIN, DHT_TIPO);
float measuredTemperature;
int error_code;
float measuredHumidity;

// Host PC Communication channels
Serial      Terminal(USBTX, USBRX);         // Tx, Rx

int main()
{
    
    while (true) {        
        Terminal.printf("\rReading DHT ... ");
        error_code = dht.readData();
        if (error_code){
            Terminal.printf("\r\nError Code: %d \r\n", error_code); 
            Terminal.printf("\r\n");
            
            Terminal.printf("\r\nData: %d %d %d %d %d \v\v\v\v", dht.DHT_data[0], dht.DHT_data[1],dht.DHT_data[2], dht.DHT_data[3], dht.DHT_data[4]);
        }              
        else{
            measuredHumidity = dht.ReadHumidity();                          //Se lee la humedad
            Terminal.printf("\r\nHumedad: %.2f", measuredHumidity);            
            measuredTemperature = dht.ReadTemperature(CELCIUS);                //Se lee la temperatura: CELCIUS=0,FARENHEIT=1,KELVIN=2
            Terminal.printf("\r\nData: %d %d %d %d %d ", dht.DHT_data[0], dht.DHT_data[1],dht.DHT_data[2], dht.DHT_data[3], dht.DHT_data[4]);
             
            Terminal.printf("\r\nTemperatura: %.2f \r\n\v\v\v\v\v\v\v\v\v", measuredTemperature);

        }
        wait(4);
          
    }
}