#include "mbed.h"
#include "C12832_lcd.h"
#include <stdlib.h> 


#define MAX_ROUNDS 100
#define SEED_COUNT 8

C12832_LCD lcd;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

PwmOut spkr(p26);

DigitalIn down(p12);
DigitalIn up(p15);
DigitalIn left(p13);
DigitalIn right(p16);

DigitalIn middle(p14);

void play(float val){
    spkr.period(1.0/val);
    spkr=0.5;
    wait(0.2);
    spkr=0.0;
}


void tone1(){
    lcd.fillcircle(63,25,5,1);
    play(2000);
    lcd.cls();
}

void tone2(){
    lcd.locate(0,10);
    lcd.fillcircle(5,15,5,1);
    play(2250);
    lcd.cls();
}

void tone3(){
    lcd.fillcircle(63,5,5,1);
    play(2500);
    lcd.cls();
}

void tone4(){
    lcd.fillcircle(122,15,5,1);
    play(2650);
    lcd.cls();
}


int round = 1;
int sequence[MAX_ROUNDS];

int seed(){
    lcd.cls();
    lcd.printf("Seed by moving the joystick in any direction");
    lcd.locate(0,20);
    
    lcd.printf("%d",SEED_COUNT);
    lcd.locate(10,20);
    lcd.printf("times.");
    
    int i=0;
    int x=1;
    while(i<SEED_COUNT){
        if(down){
            x=x*37;
            i++;
        }
        if(left){
            x=x*135;
            i++;
        }
        if(up){
            x=x+31;
            i++;
        }
        if(right){
            x=x+781;
            i++;
        }
        lcd.locate(0,20);
        lcd.printf("%d",SEED_COUNT-i);
        wait(0.2);    
    }
    return x;
}

int main(){
    srand(seed());
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Game start!");
    wait(2);
    lcd.cls();
    int check = 0;
    bool failed = false;
    while(round<MAX_ROUNDS){
        bool done = false;
        lcd.cls();
        
        //Play the generated sequence
        sequence[round-1] = rand() % 4;
        for(int i=0; i<round; i++){
            switch(sequence[i]){
                case 0:
                    tone1();
                    break;
                case 1:
                    tone2();
                    break;
                case 2:
                    tone3();
                    break;
                case 3:
                    tone4();
                    break;
            };
            wait(0.2);
        }
        
        //Imitate the sequence
        check=0;
        while(!done){
            if(down){
                tone1();
                if(sequence[check] == 0){
                    failed = false;
                    check++;
                }else{
                    failed = true;
                    done = true;
                }
            }
            if(left){
                tone2();
                if(sequence[check] == 1){
                    failed = false;
                    check++;
                }else{
                    failed = true;
                    done = true;
                }
            }
            if(up){
                tone3();
                if(sequence[check] == 2){
                    failed = false;
                    check++;
                }else{
                    failed = true;
                    done = true;
                }
            }
            if(right){
                tone4();
                if(sequence[check] == 3){
                    failed = false;
                    check++;
                }else{
                    failed = true;
                    done = true;
                }
            }
            if(check==round)
                done = true;
            wait(0.2);
        }
        //Fail -> Restart
        if(done && failed){
            lcd.locate(0,0);
            lcd.printf("You lost on round %d, restarting!", round);
            wait(1);
            round=0;
        //Succeed -> Continue
        }else{
            lcd.locate(0,0);
            lcd.printf("Round %d cleared!", round);
                        
        }
        wait(1);
        round++;
    }
}