#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "Game.h"
#include "uLCD_Multiscreen.h"


//already defined
//#define SIZE_X       128
//#define SIZE_Y       128
 
//display
uLCD_4DGL screen1(p28, p27, p11);
uLCD_4DGL screen2(p9, p10, p11);
std::vector<uLCD_4DGL*> my_screens;


//inputs
AnalogIn sliderh(p15);
AnalogIn sliderv(p16);



//game objects




int main() {
    my_screens.push_back(&screen1);
    my_screens.push_back(&screen2);
uLCD_Multiscreen multiscreen(my_screens);
Controller  controller(sliderh, sliderv);
vec2        screen = {SIZE_X, SIZE_Y};
Renderer    gfx(multiscreen, screen);
Game        game(gfx, controller);



    multiscreen.setBaudRate(3000000);
    multiscreen.changeBackground(0x444444);
    gfx.background = 0x444444;
    multiscreen.cls();
    //multiscreen.unfilledRectangle(0, 0, 50, 10, -1);
    
    while(true){
        int x = sliderh.read()* 1000;
        int y = sliderv.read()* 1000;

        //printf(controller.sliderv );
        game.loop();
        game.getInput(x, y);
        //Thread::wait(10);
    }
}