#include "Graphics.h"



class Controller
{
public:

    AnalogIn& sliderh;
    AnalogIn& sliderv;

public:
    Controller(AnalogIn& sliderh, AnalogIn& sliderv) : sliderh(sliderh), sliderv(sliderv) {

    }
};

class Game
{
private:
    Renderer& renderer;
    Controller& controller;
    Scene scene;

public:
    Game(Renderer& renderer, Controller& ctrl)
        : renderer(renderer), controller(ctrl) {
        
        scene.bg = renderer.background;

        buildScene();
    }

private:
    void buildScene() {


        Block pad;
        pad.locked = true;
        pad.coord.x = 10;
        pad.coord.y = 10;
        pad.copy();
        pad.color = -1;
        scene.paddle = pad;
    }


public:
    void getInput(int posx, int posy) {
        scene.paddle.store_prev();

        if (posx > 600) {
            scene.paddle.coord.x = scene.paddle.coord.x + 5;
        } else if (posx < 400) {
            scene.paddle.coord.x = scene.paddle.coord.x - 5;
        }
        
        if (posy > 600) {
            scene.paddle.coord.y = scene.paddle.coord.y + 5;
        } else if (posy < 400) {
            scene.paddle.coord.y = scene.paddle.coord.y - 5;
        }
        

        scene.paddle.updated = true;
    }
    
    
    void loop() {
        renderer.render(scene);
    }
    

};

