#include "uLCD_Multiscreen.h"

struct vec2 {
    float x;
    float y;
};


class Renderer;


class Block
{
    friend Renderer;

private:

    vec2 next_coord;
    vec2 next_size;

public:
    bool updated;
    bool locked;

    bool render;
    vec2 coord;
    vec2 size;

    int color;

    vec2 prev_coord;
    vec2 prev_size;

    Block() :  updated(true), locked(false), render(true) {
        coord.x = 0;
        coord.y = 0;
        color = RED;
        size.x = 2;
        size.y = 2;
    }
    
    virtual void next_swap(){
      coord = next_coord;
      size = next_size;

  }

    void store_prev() {
        prev_coord = coord;
        prev_size = size;
    }
    
    void copy() {
        prev_coord = coord;
        prev_size = size;

        next_coord = coord;
        next_size = size;

    }

    
};


class Scene
{
public:
    int bg;
    Block paddle;

};


class Renderer
{
private:
public:
    uLCD_Multiscreen& g;
    int background;
    vec2 screen;

    Renderer(uLCD_Multiscreen& gfx, vec2 screen) : g(gfx), screen(screen) {
    }
    void render(Scene s) {


        //draw paddle
        {
            Block* b = &(s.paddle);
            if(b->updated) {
                //draw over where it was
                g.unfilledCirlce(b->prev_coord.x, b->prev_coord.y, 10, background);       //x1,y1,x2,y2,color
                //draw new location
                g.unfilledCirlce(b->coord.x, b->coord.y, 10,  b->color);       //x1,y1,x2,y2,color

                b->updated = false;
            }
        }




    }
};