#include "LSM9DS0.h"
#include <sstream>
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW
#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);

void print_accelerometer();
void print_compass_data();
void print_temperature();

int main()
{
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("------ LSM0DS0 Demo -----------\n");
    while(1) {
        led1 = !led1;
        print_accelerometer();
        print_compass_data();
        print_temperature();
        wait_ms(500);
    }
}

void print_accelerometer()
{
    imu.readAccel();
    pc.printf("A: x-axis: %d y-axis: %d z-axis: %d\n", imu.ax, imu.ay, imu.az);
}
void print_compass_data()
{
    imu.readMag();
    float compassHeading = imu.calcHeading();
    std::string direction = "";
    if (compassHeading > 22.5 & compassHeading <= 67.5) {
        direction = "NE";
    } else if (compassHeading > 67.5 & compassHeading <= 112.5) {
        direction = "E";
    } else if (compassHeading > 112.5 & compassHeading <= 157.5) {
        direction = "SE";
    } else if (compassHeading > 157.5 & compassHeading <= 202.5) {
        direction = "S";
    } else if (compassHeading > 202.5 & compassHeading <= 247.5) {
        direction = "SW";
    } else if (compassHeading > 247.5 & compassHeading <= 292.5) {
        direction = "W";
    } else if (compassHeading > 292.5 & compassHeading <= 337.5) {
        direction = "NW";
    } else {
        direction = "N";
    }
    pc.printf(direction.c_str());
    pc.printf("\n");
    pc.printf("Degree: %f\n", compassHeading);


}
void print_temperature()
{
    imu.readTemp();
    pc.printf("T: %f C\n", imu.temperature_c);
}
