/******************************************************************************
¬   Knightrider.c                                                             ¬
¬   Uses the onboard LEDS on mBED to continuously perform LED chaser sequence ¬
¬   LED Chaser sequence timimg can be changed by using the serial comms and   ¬
¬   activity on digital port.                                                 ¬
¬                                                                             ¬
¬   Written by RandomSingh. 05/2010                                           ¬
¬                                                                             ¬
******************************************************************************/

/* Libraries */
#include "mbed.h"

/* Output Assignements */
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

/* Input Assignments */
DigitalIn enable(p5);

/* Interrupt Assignemnts */
InterruptIn event(USBRX);
InterruptIn event2(p16);

/* Serial Port Assignment */
Serial pc(USBTX, USBRX); // tx, rx


/* Macro Definitions */
#define LONGER 0.9
#define LONG 0.4
#define SHORT 0.05
#define FWD 0
#define REV 1
#define SLOW 0
#define MEDIUM 1
#define FAST 2
#define ON 1
#define OFF 0

/* Prototype Function declartions */
void initialise_LEDS();
void trigger();
void LED_chaser_sequence();

/* External Variables */
int timer;
short speed;
int direction = FWD;
int phase;



int main() {

    event.rise(&trigger);           // Set up interrupts
    event2.rise(&trigger);
    initialise_LEDS();
    pc.printf("Speed is slow\r\n"); // Default speed is slow
    
    while(1) 
    {// Start of while
    
        LED_chaser_sequence();
    
    }// End of while
}// End of main


/******************************************************************************
¬   trigger function - ISR                                                    ¬
¬   If activity on the rx line of the serial port then this ISR executes      ¬
¬   This ISR changes the external variable 'speed' value, which is used for   ¬
¬   timing of the sequence.                                                   ¬
¬                                                                             ¬
¬   The objective of this ISR is to change the 'speed' value & transmit a     ¬
¬   a message to the serial port.                                             ¬                                                                         
¬                                                                             ¬
******************************************************************************/
void trigger()
{// Start of trigger
        if(speed > FAST)                       // This bit of the code limits value of speed to 2
        {// Start of if                        // as there are only three levels of timing 
         speed = SLOW;
         pc.printf("Speed is slow\r\n");
        }// End of if
        else
        {// Start of else
         speed++;
        }// End of else
    
    if(speed == MEDIUM)
        pc.printf("Speed is medium\r\n");
    
    if(speed == FAST)
        pc.printf("Speed is fast\r\n");

}// End of trigger

void LED_chaser_sequence()
{// Start of LED_chaser_sequence
switch(phase)
    {// Start of switch
    case 0:  myled = OFF;
             myled2 = OFF;
             myled3 = OFF;
             myled4 = OFF;
             wait(LONG);
             wait(SHORT);
             direction = FWD;
             phase++;
             break;
    case 1:  myled = ON;
             myled2 = OFF;
             myled3 = OFF;
             myled4 = OFF;
             wait(SHORT);
             if(direction == FWD)
             {// Start of if
                phase++;
             }// End of if
             else
             {// Start of else
                phase--;
             }// End of else
             break;
    case 2:  myled = OFF;
             myled2 = ON;
             myled3 = OFF;
             myled4 = OFF;
             wait(SHORT);
                if(direction == FWD)
             {// Start of if
                phase++;
             }// End of if
             else
             {// Start of else
                phase--;
             }// End of else
             break;
    case 3:  myled = OFF;
             myled2 = OFF;
             myled3 = ON;
             myled4 = OFF;
             wait(SHORT);
                if(direction == FWD)
             {// Start of if
                phase++;
             }// End of if
             else
             {// Start of else
                phase--;
             }// End of else
             break;
   case  4:  myled = OFF;
             myled2 = OFF;
             myled3 = OFF;
             myled4 = ON;
             wait(SHORT);
             direction = REV;
             phase--;
             break;
   default : 
            wait(SHORT);
            break;
            
    }// End of switch
    
    switch(speed)
    {// Start of switch
        case SLOW   : wait(LONGER);
                      break;
        case MEDIUM : wait(LONG);
                      break;
        case FAST   : wait(SHORT);
                      break;
        default     :
                      wait(SHORT);
                      break;
    }// End of switch

}// End of LED_chaser_sequence

void initialise_LEDS()
{// Start of initialise_LEDS

    myled = OFF;
    myled2 = OFF;
    myled3 = OFF;
    myled4 = OFF;

}// End of initialise_LEDS