#include "mbed.h"
#include "USBHID.h"

// We declare a USBHID device.
// HID In/Out Reports are 64 Bytes long
// Vendor ID (VID):     0x15A2
// Product ID (PID):    0x0138
// Serial Number:       0x0001
USBHID hid(64, 64, 0x15A2, 0x0138, 0x0001, true);

//Setup Digital Outputs for the LEDs on the FRDM
//PwmOut red_led(LED1);
//DigitalOut green_led(LED2);
//DigitalOut blue_led(LED3);

//Setup PWM and Digital Outputs from FRDM-KL25Z to FRDM-17510
PwmOut IN1(PTC8); // Pin IN1 input to MC34931 (FRDM PIN Name)
PwmOut IN2 (PTA5); // Pin IN2 input to MC34931 (FRDM PIN Name)
DigitalOut EN(PTE0); // Pin EN input to MC34931 (FRDM PIN Name)
DigitalOut DIS(PTA2); //  Pin D1 input to MC34931 (FRDM PIN Name)
DigitalIn STATUS(PTB3);
AnalogIn CFB(PTB0);
//DigitalOut READY(PTC7); // Pin READY input to Motor Control Board (FRDM PIN Name)

//Variables
int pwm_freq_lo;
int pwm_freq_hi;
int frequencyHz = 500;
int runstop = 0;
int direction = 1;
int braking;
int dutycycle = 75;
int newDataFlag = 0;
int status = 0;
uint16_t CurrFB; 
uint16_t CFBArray[101];
uint32_t CFBTotal;
uint16_t CFBAvg;
uint16_t CFBtemp;

//storage for send and receive data
HID_REPORT send_report;
HID_REPORT recv_report;

bool initflag = true;

// USB COMMANDS
// These are sent from the PC
#define WRITE_LED       0x20
#define WRITE_GEN_EN  0x40
#define WRITE_DUTY_CYCLE  0x50
#define WRITE_PWM_FREQ  0x60
#define WRITE_RUN_STOP  0x70
#define WRITE_DIRECTION  0x71
#define WRITE_BRAKING  0x90
#define WRITE_RESET  0xA0
#define WRITE_D1  0xB1
#define WRITE_D2_B  0xC1

#define scaleFactor 0.11868

// LOGICAL CONSTANTS
#define OFF             0x00
#define ON              0x01


int main() 
{
    send_report.length = 64;
    recv_report.length = 64;
    
    
    while(1) 
    {
               //try to read a msg
        if(hid.readNB(&recv_report)) 
        {
            switch(recv_report.data[0])     //byte 0 of recv_report.data is command   
            {
//-----------------------------------------------------------------------------------------------------------------
//          COMMAND PARSER
//-----------------------------------------------------------------------------------------------------------------
////////
                case WRITE_LED:
                    break;
////////                    

////////              
                 case  WRITE_DUTY_CYCLE:
                    dutycycle = recv_report.data[1];
                    newDataFlag = 1;
                    break;
////////                
                 case  WRITE_PWM_FREQ:                      //PWM frequency can be larger than 1 byte
                    pwm_freq_lo = recv_report.data[1];      //so we have to re-assemble the number
                    pwm_freq_hi = recv_report.data[2] * 100;
                    frequencyHz = pwm_freq_lo + pwm_freq_hi;
                    newDataFlag = 1;
                    break;
////////                
                case  WRITE_RUN_STOP:
                    newDataFlag = 1;                
                    if(recv_report.data[1] != 0)
                    {
                         runstop = 1;
                    }
                    else
                    {
                         runstop = 0;
                    } 
                    break;                    
 
////////                
                case  WRITE_DIRECTION:
                    newDataFlag = 1;
 
                    if(recv_report.data[1] != 0)
                    {
                         direction = 1;
                    }
                    else
                    {
                         direction = 0;
                    }                    
                    break;
////////
                case  WRITE_BRAKING:
                    newDataFlag = 1;                
                    if(recv_report.data[1] == 1)
                    {
                            braking = 1;
                    }
                    else
                    {
                            braking = 0;
                    }
                    break;
////////                   
                case WRITE_D1:
                    newDataFlag = 1;                                
                    if(recv_report.data[1] == 1)
                    {
                        DIS = 1;
                    }
                    else
                    {
                        DIS = 0;
                    }
                    break;                    
////////
                case WRITE_D2_B:
                    newDataFlag = 1;                
                    if(recv_report.data[1] == 1)
                    {
                       EN  = 0;
                    }
                    else
                    {
                       EN = 1;
                    }
                    break;                    
                
////////                
                default:
                    break;
            }// End Switch recv report data[0]

//-----------------------------------------------------------------------------------------------------------------
//      end command parser    
//-----------------------------------------------------------------------------------------------------------------

            status = STATUS;    
            send_report.data[0] = status;      // Echo Command
            send_report.data[1] = recv_report.data[1];      // Echo Subcommand 1
            send_report.data[2] = recv_report.data[2];      // Echo Subcommand 2
            send_report.data[3] = 0x00;
            send_report.data[4] = 0x00;
            send_report.data[5] = 0x00;
            send_report.data[6] = (CFBAvg << 8) >> 8;
            send_report.data[7] = CFBAvg >> 8;
              
            //Send the report
            hid.send(&send_report);
        }// End If(hid.readNB(&recv_report))
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//End of USB message handling        
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        CurrFB = CFB.read_u16();
        CFBArray[0] = CurrFB;
        CFBTotal = 0;
        int i = 0;
        for(i=0; i<100; i++)
        {
        CFBTotal = CFBTotal + CFBArray[i];
        }
        CFBAvg =  CFBTotal / 100;
        
        for(i=100; i>=0; i--)
        {
           
           CFBArray[i+1] = CFBArray[i];
        }

        if(newDataFlag != 0)                            //GUI setting changed
        {
            newDataFlag = 0;
            if(runstop != 0)                            //Running 
            {
                if(direction == 0)                      //reverse
                {
                    if(braking == 1)                    //dynamic
                    {
                        IN1.period(1/(float)frequencyHz);    
                        IN1 = (float)dutycycle/100.0;
                        IN2 = 1;
                    }
                    else                                //coast
                    {
                        IN1 = 0;
                        IN2.period(1/(float)frequencyHz);  
                        IN2 = (float)dutycycle/100.0;                                    
                    }
                }
                else                                    //forward
                {
                    if(braking == 1)                    //dynamic    
                    {
                        IN1 = 1;
                        IN2.period(1/(float)frequencyHz); 
                        IN2 = (float)dutycycle/100.0;   
                    }
                    else                                //coast
                    {
                        IN1.period(1/(float)frequencyHz);  
                        IN1 = (float)dutycycle/100.0;                                    
                        IN2 = 0;
                    }
                }                                    
           }
           else                                         //Stopped
           {
                if(braking == 1)    //braking
                {
                    IN1.period(1);
                    IN2.period(1);
                    IN1.write(1);
                    IN2.write(1);    
                }
                else                //coasting
                {
                    IN1.period(1);
                    IN2.period(1);                 
                    IN1.write(0);
                    IN2.write(0);  

                }
            }
        }
    }
}
