//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too
 
//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                              
                              
#include "mbed.h"
#include "MFRC522.h"
#include "SPI.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

#define ECHO_SERVER_PORT   7
 
// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
//#define MF_RESET    D8
 
#define SPI_MOSI D11
#define SPI_MISO D12
#define SPI_SCK D13
#define SPI_CS D10
#define MF_RESET D9
DigitalOut l1(D4);
DigitalOut l2(D5);
DigitalOut LedGreen(LED1);
 
//Serial connection to PC for output
//Serial pc(USBTX, USBRX);
 
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
 
int main(void) {
    //pc.printf("starting...\n");
    
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("Wait a second...\r\n");
    char* topic = "openhab/parents/command";
    MQTTEthernet ipstack = MQTTEthernet();
    
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "172.16.73.4";
    int port = 1883;
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\n", rc);
        
    printf("Topic: %s\r\n",topic);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "parents";

    if ((rc = client.connect(data)) == 0)
        printf("rc from MQTT connect is %d\n", rc);
 
  //Init. RC522 Chip
  RfChip.PCD_Init();
 
  while (true) {
    //LedGreen = 1;
    pc.printf("enterd loop...\n");
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
 
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
 
    //LedGreen = 0;
    char data[20]="";
    char data1[20]="";
    
    // Print Card UID
    pc.printf("Card UID: ");
    printf("Size of UID: %d \n",RfChip.uid.size);
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      char temp[5];
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
      sprintf(temp,"%X02", RfChip.uid.uidByte[i]);
      strcat(data,temp);
    }
    
    /*    
    pc.printf("\n\r");
    printf("%s\n\r",data);
    */
 
    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf(" \nPICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
    
    if(strcmp(data,"5C02820285024502")==0)
    {   
        strcat(data1,"fruits");
    }
    if(strcmp(data,"B3026802A002202")==0)
    {
        strcat(data1,"vegatables");
    }
    if(strcmp(data,"F2029C02AC021F02")==0)
    {
        strcat(data1,"milk");
    
    MQTT::Message message;
    char buf[100];
    sprintf(buf, "%s", data1);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)data1;
    message.payloadlen = strlen(data1);
    rc = client.publish("grocery", message); 
    client.yield(60000);
    memset(data1, '\0',sizeof(data1)); 
  }
}
}