/*
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

  * Demo Program
  * Barometer Sensor (Altimeter) MS5803-01BA of MEAS Switzerland     (www.meas-spec.com).
  * The driver uses I2C mode (sensor PS pin low).
  * Other types of MEAS are compatible but not tested.
  * Written by Raig Kaufer distribute freely!
 */

#include "mbed.h"
#include "MS5803.h"
#include "USBSerial.h"

#define debug
#ifdef debug
USBSerial serial;
Serial pc(USBTX, USBRX);
#endif

MS5803     press_sensor( p9, p10, ms5803_base_addr );           // sda, scl, I2C_address 0x76 or 0x77 look at MS5803.h

int main() {

#ifdef debug
        wait( 3 );
        serial.printf("MS5803 demo");
#endif

    while ( 1 ) {
#ifdef debug
        press_sensor.Barometer_MS5803();
        serial.printf("%4.1f (mBar)\r\n", press_sensor.MS5803_Pressure());
        serial.printf("%4.1f (deg C)\r\n", press_sensor.MS5803_Temperature());
#endif

        wait( 1 );
    }
}
