#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#define TSILIMIT 0.99
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
float tsidata;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    
    dataTimer.start();
    dataTimer.reset();
}

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    float lastTouch = 0.0;
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;

    initialize_global_vars();

     while (true) {
        if (dataTimer.read() > DATAINTERVAL) {
            dataTimer.reset();
            tsidata = tsi.readPercentage();
            if (tsidata > TSILIMIT){
                gled = 0.0;
                rled = 0.0;
            }else {
                if (fabs(tsidata - lastTouch)< PRINTDELTA) {
                  pc.printf("\n Position %f\n\r", tsidata);              
                }
                sprintf (lcdData,"%0.4f",tsidata);  
                LCDMess(lcdData);
                gled = tsidata;
                rled = 1.0 - tsidata;               
            }
            lastTouch = tsidata;
        }
    }
}