#include "mbed.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BLINKTIME 0.5 //Changed time from .3 to .5
#define BUTTONTIME 0.2
#define LCDCHARLEN 35 //Changed limit 
#define NUMMESS 2
#define LRED "RED"
#define LGREEN "GREN"
#define PRED "You pressed the red button\r\n" //changed the output 
#define PGREEN "You pressed the green button\r\n" //changed the output
#define PROGNAME "blink_kl46z_buttton LCD v2\r\n"

// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display

// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states

bool ledState = LEDON;

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}
 
void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    LEDTimer.start();
    LEDTimer.reset();  
    allLEDsOff();
} 
// --------------------------------
 int main() {
    int i; 
    int currentLED = 0;
    char rMess[NUMMESS][LCDCHARLEN]={LGREEN, LRED}; // for LCD
    char pMess[NUMMESS][LCDCHARLEN]={PRED, PGREEN}; // for pc serial port

    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
    LCDMess(rMess[currentLED]);
    pc.printf(pMess[currentLED]);
// End of setup
    while(true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    allLEDsOff();  
                    LCDMess(rMess[i]);
                    pc.printf(pMess[i]); 
                    currentLED = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
        if(LEDTimer.read() > BLINKTIME){
            LEDTimer.reset();               
            ledState = !ledState; // Flip the general state
            LEDs[currentLED] = ledState;
        }
    // Do other things here between times of reading and flashing
    }
}