#include "mbed.h"
#include <math.h>
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define FEDOFF true
#define NUMBUTS 2
#define LBUT PTC12
#define RBUT PTC3
#define ARGUENTSTATE 0
#define ARGUMENTANSWER 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kSquareRoot_Calculator_KL46Z\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer buttonTimer;
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};

float tsiData;
int displayState;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    
    buttonTimer.start();
    buttonTimer.reset();
    dataTimer.start();
    dataTimer.reset();
}

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

float squareRoot(int val) {
    float xNew = 0.0;
    float xOld = val/2.0;
    int max = 40;
    float epsilon = 0.0000007;
    float delta;
    
    for (int i = 0; i < max; i++) {
        xNew = 0.5 * (xOld + (val/xOld) );
        delta = abs(xNew - xOld);
        //Check Convergence
        if (delta < epsilon) {
            break;
        } else {
            xOld = xNew;
        }
    }
    
    return xNew;
}

int main(void) {
    int i;  
    float holdVal;
    float lastTouch = 0.0;
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;
    float tempTSI;

    initialize_global_vars();

    while (true) {
        if (buttonTimer > BUTTONTIME) {
            for (i = 0; i < NUMBUTS; i++) {
                if(!buttons[i]) {
                    displayState = i;
                    
                }
            }
            //Get slider value
            if (displayState == 0) {
                rled = 0.0;
                gled = 1.0;
                if (dataTimer.read() > DATAINTERVAL) {
                    dataTimer.reset();
                    tempTSI = tsi.readPercentage() *100;
                    if (tempTSI > TSILIMIT) {
                        tsiData = tempTSI;
                        if (tempTSI > TSILIMIT) {
                            tsiData = tempTSI;
                            if (fabs(tsiData - lastTouch) > PRINTDELTA) {
                                pc.printf("Position %0.0f\n\r", tsiData);
                            }
                        }
                        lastTouch = tsiData;
                    }
                    
                }        
                sprintf(lcdData,"%0.0f",tsiData);
                LCDMess(lcdData);                      
            } 
            //Perform SquareRoot
            else {               
                rled = 1.0;
                gled = 0.0; 
                
                holdVal = squareRoot(tsiData);  
                sprintf(lcdData,"%2.2f",holdVal); 
                if (holdVal < 0.0) {
                     sprintf(lcdData, "z%2.2f", fabs(holdVal));
                }
                
                LCDMess(lcdData);                      
            }
            buttonTimer.reset();
        }   
    }
}