#include "mbed.h"
#define MAX 4

Serial xbee(PA_9, PA_10); // tx, rx
AnalogIn ain_0(PA_5);
AnalogIn ain_1(PA_6);
AnalogIn ain_2(PA_4);
AnalogIn ain_3(PA_7);

DigitalIn sw_0(PB_3);
DigitalIn sw_1(PB_5);
DigitalIn sw_2(PB_4);

DigitalOut myled(PA_8);

Ticker adc_timer;
Ticker Tr_timer;
uint8_t data[MAX];

/*符号化(*/
uint8_t ChannelCoding(float data_f, int index)
{
    uint8_t tmp;
    tmp = data_f * 31;
    return ((tmp << 3) | index);
}

/*送信*/
void transmit(void)
{
    static int i = 0;
    xbee.putc(data[i]);
    if(++i >= MAX)i=0;
}

/*受信*/
void receve(void)
{
    myled = 1;
}
    
void adcRead(void){
    /*ステッピングモーター*/
    data[0] = ChannelCoding(ain_0, 0);
    /*EX球*/
    data[1] = ChannelCoding(ain_1, 1);
    /*室内灯*/
    data[2] = ChannelCoding(ain_2, 2);
    
    data[3] = ChannelCoding(ain_3, 3);
}

int main() {
    for(int i=0; i<MAX; i++)data[i] = ChannelCoding(0.0f, i);
    myled = 0;
    sw_0.mode(PullUp);
    sw_1.mode(PullUp);
    sw_2.mode(PullUp);
    xbee.baud(9600);
    xbee.format(8, Serial::None, 1);
    xbee.attach(&receve, Serial::RxIrq);//受信割り込み
    Tr_timer.attach_us(&transmit, 20000);//送信
    adc_timer.attach_us(&adcRead, 20000);//ADC
    while(1)__WFI();
}