#include "mbed.h"
#define MAX 4

/*ステッピングモーター*/
Ticker step_timer;
DigitalOut APHASE(p5);
DigitalOut AENBL(p6);
DigitalOut BPHASE(p7);
DigitalOut BENBL(p8);

/*MCP4922*/
Ticker spi_timer;
SPI spi(p11, p12, p13);//mosi(SDO), miso, sclk
DigitalOut CS(p14);
DigitalOut LDAC(p17);

/*RGB_LED_3*/
Ticker rgb_timer;
BusOut signal(p24, p25, p26);
PwmOut R_led(p22);
PwmOut G_led(p21);
PwmOut B_led(p23);

/*シリアル通信(xbee)*/
Serial xbee(p28, p27); // tx, rx

/*受信データ格納*/
uint8_t data[MAX] = {0};
uint8_t tmp_data[MAX][3] ={0};

void stepper(void);
void spi_write(unsigned int config, unsigned int mask, unsigned int value);
void LightBulb(void);
void DomeLapm(float val);
void RGB_LED(void);
void ArrayShift_3(uint8_t array[3]);
uint8_t MedianFilter_3(uint8_t src[3]);
void ChannelDecoding(uint8_t CodeWord);
void receve(void);

/*ステッピングモーター*/
void stepper(void)
{
    static unsigned int cnt = 0;
    static int i = 1;
    static unsigned int delay = 1000;
    
    delay = (255 - data[0]) + 10;
    
    if((++cnt > delay) && data[0]!=0)
    {
        AENBL = 1;
        BENBL = 1;
        switch(i)
        {
        case 1:
            APHASE = 1;
            break;
        case 2:
            BPHASE = 1;
            break;
        case 3:
            APHASE = 0;
            break;
        case 4:
            BPHASE = 0;
            break;
        }
        
        if(++i==5)i = 1;
        cnt = 0;
    }
    else if(data[0]==0)
    {
        AENBL = 0;
        BENBL = 0;
    }
}

/*spiでの書き込み用関数*/
void spi_write(int config, int mask, int value)
{
    unsigned int spi_data;
    spi_data = config | (mask & value);
    CS = 0;
    LDAC = 1;
    spi.write(spi_data);
    CS = 1;
    LDAC = 0;
}    

/*SPI通信でMCP4922(DAC)を動かすための関数*/
void LightBulb(void)
{   
    static int mask = 0b0000111111111111;
    int config;
    int value;
    
    static int EX_MAX = 2300;
    
    config = 0b0111000000000000;
    value = (data[1] * EX_MAX) * 0.0039215f;
    spi_write(config, mask, value);
}

/*室内灯(暖色系の色)*/
void DomeLamp(float val)
{
    R_led = val;
    G_led = 0.38f*val;
    B_led = 0.04f*val;
}
    
/*RGB_LEDをダイナミック点灯するための関数*/
void RGB_LED(void)
{
    static uint8_t dig;
    uint8_t binary = 0b00001;
    
    DomeLamp((float)data[3]*0.0039215f);

    signal = binary << dig;
    if(++dig == 3)dig = 0;
}

/*配列をシフトする*/
void ArrayShift_3(uint8_t array[3])
{
    array[2] = array[1];
    array[1] = array[0];
}

/*メディアンフィルター（要素数３の配列）*/
uint8_t MedianFilter_3(uint8_t src[3])
{
    if(src[0]>=src[1])
    {
        if(src[1]>=src[2])return src[1];
        else if(src[0]<=src[2])return src[0];
        else return src[2];
    }
    else if(src[0]>src[2])return src[0];
    else if(src[1]>src[2])return src[2];
    else return src[1];
}

/*復号化*/
void ChannelDecoding(uint8_t CodeWord)
{
    int index;
    index = CodeWord & 0b00000111;
    
    if(index<MAX)
    {
        tmp_data[index][0] = (CodeWord >> 3)*8.226f;
        /*ノイズ除去*/
        data[index] = MedianFilter_3(tmp_data[index]);
        ArrayShift_3(tmp_data[index]);
    }
}    

/*シリアル通信受信(xbee)*/
void receve(void)
{
    ChannelDecoding(xbee.getc());
    xbee.putc(1);
}

int main(){
    /*ステッピングモーター*/
    AENBL = 0;
    APHASE = 0;
    BENBL = 0;
    BPHASE = 0;
    step_timer.attach_us(&stepper, 100);
    
    /*spi通信(MCP4922)*/
    CS = 1;
    LDAC = 1;
    spi.format(16, 0);
    spi.frequency(1000000);
    spi_timer.attach_us(&LightBulb, 50000);
    
    /*RGB_LED_3*/
    R_led.period(0.00004);
    G_led.period(0.00004);
    B_led.period(0.00004);
    rgb_timer.attach_us(&RGB_LED, 4000);
    
    /*シリアル通信(xbee)*/
    xbee.baud(9600);
    xbee.format(8, Serial::None, 1);
    xbee.attach(&receve, Serial::RxIrq);//受信割り込み
    
    while(1);
}