
#include "calculaVelocidad.h"
#include "main.h"

double velocidadActual=0.0;
double historialVelocidades[]={0.0,0.0,0.0};
int nominado = 0;

double suavizaVelocidad(double velocidad){
  double res= velocidad*0.7+historialVelocidades[0]*0.1+historialVelocidades[1]*0.1+historialVelocidades[0]*0.1;
  return res;
 }


//A partir de las muescas de la rueda, calcula la velocidad en km/h
double calculaVelocidad(int periodo, int acumulador){
    double minutos = periodo / 60000.0;
    double revoluciones = acumulador / 20.0;
    double revolucionesporMinuto = revoluciones/minutos;     
    double velocidad = revolucionesporMinuto*3.4*2*3.141592/60/100*3.6;
    velocidad = suavizaVelocidad(velocidad);
    historialVelocidades[nominado]=velocidad;
    nominado++;
    if(nominado >= 3){
      nominado = 0;
    }
    
    velocidadActual = velocidad;  

 return velocidad;
}
  
 


