#include "mbed.h"
#include "ADXL345.h"
#include "SDFileSystem.h"
#include "SCP1000.h"

DigitalOut myled(LED1);
ADXL345 adxl345(p5, p6, p7, p9);
SCP1000 scp1000(p5, p6, p7, p8);
SDFileSystem sd(p5, p6, p7, p10, "sd");
I2C i2c(p28, p27);
LocalFileSystem local("local");
Serial pc(USBTX, USBRX);

float toG(float value) {
    return value / 256;
} //ADXL345

short int toDeg_Sec(short int value) {
    //return (value - ((scp1000.readTemperature() + 13200.0) / 280.0 + 35.0)) / 16.4;
    //return (value - ((20 + 13200.0) / 280.0 + 35.0)) / 16.4; //at 20degC
    return value / 16.4;
} //IMU3000

short int read_x_2byte;
short int read_y_2byte;
short int read_z_2byte;

Ticker tick; //Timer IMU3000
double interval = 10; //[ms] IMU3000
const int adrIMU3000 = 0xD0;//8-bit write IMU3000


int main() {
    
    /*FILE *fp = fopen("/sd/Data.txt","a");
    fprintf(fp, "X, Y, Z, Xw, Yw, Zw, Pa\n");
    fclose(fp);*/

    int readings[3] = {0, 0, 0};

    adxl345.setPowerControl(0x00);          //Go into standby mode to configure the device.
    adxl345.setDataFormatControl(0x0B);     //Full resolution, +/-16g, 4mg/LSB.
    adxl345.setDataRate(ADXL345_3200HZ);    //3.2kHz data rate.
    adxl345.setPowerControl(0x08);          //Measurement mode.
    
    i2c.frequency(400000); //set 400kHz
    
    //pc.baud(115200);
    
    char PWR_M[2] = {0x3E, 0x80};
    i2c.write(adrIMU3000, PWR_M, 2, true);
    char SMPL[2] = {0x15, 0x00};
    i2c.write(adrIMU3000, SMPL, 2, true);
    char DLPF[2] = {0x16, 0x18};
    i2c.write(adrIMU3000, DLPF, 2, true);
    char INT_C[2] = {0x17, 0x05};
    i2c.write(adrIMU3000, INT_C, 2, true);
    char PWR_M2[2] = {0x3E, 0x00};
    i2c.write(adrIMU3000, PWR_M2, 2, true);
    
    char adrIMU3000_y[1];
    char readIMU3000[8];
    
    read_x_2byte = 0;
    read_y_2byte = 0;
    read_z_2byte = 0;
    

    while (1) {
        
        adxl345.getOutput(readings);      
        float accelX = toG((int16_t)readings[0] ); //13-bit, sign extended values.
        float accelY = toG((int16_t)readings[1] );
        float accelZ = toG((int16_t)readings[2] );
        
    
        adrIMU3000_y[0] = 0x1D; //register GYRO_XOUT_H
    
        i2c.write(adrIMU3000, adrIMU3000_y , 1);
        i2c.read(adrIMU3000, readIMU3000, 8);
    
        read_x_2byte = ((readIMU3000[0] << 8) + readIMU3000[1]);
        read_y_2byte = ((readIMU3000[2] << 8) + readIMU3000[3]);
        read_z_2byte = ((readIMU3000[4] << 8) + readIMU3000[5]);
        short int Xw = toDeg_Sec(read_x_2byte );
        short int Yw = toDeg_Sec(read_y_2byte );
        short int Zw = toDeg_Sec(read_z_2byte );
        
        scp1000.readPressure();
        scp1000.readTemperature();
        
        int Pa = scp1000.readPressure();
        int Dc = scp1000.readTemperature();
        
        FILE *fp = fopen("/local/Data.txt","a");
        myled = 1;               
        //fprintf(fp, "%f, %f, %f, %d, %d, %d, %f, %f\n", accelX, accelY, accelZ, Xw, Yw, Zw, Pa, Dc);
        //fprintf(fp, "%f, %f, %f", accelX, accelY, accelZ);
        fprintf(fp, "%d, %d, %d", Xw, Yw, Zw);
        //fprintf(fp, "%f, %f\n", Pa, Dc);
        fclose(fp);
        myled = 0;
        
        wait(1);
        
    }
}