#include "mbed.h"
#include "SC16IS750.h"
#include "DisplayN18.h"

#define D_SCL                  P0_4
#define D_SDA                  P0_5
#define ESP8266_RST            P0_10
#define RETRO_GAME
#define RETRO_GAME0

#define PI         (3.1415926535f) 
#define HALF_PI    (0.5f * PI) 
#define TWO_PI     (2.0f * PI)  
#define TWO_PI_INV (1.0f / TWO_PI)  

#pragma once

class ROBOT {  

    static const char* LOSE_1;
    static const char* LOSE_2;
    static const char* SPLASH_1;
    static const char* SPLASH_2;
    
    static const int BALL_RADIUS        =  3;
    static const int PADDLE_WIDTH       = 38;
    static const int PADDLE_HEIGHT      =  4;
    static const int PADDLE_SPEED       =  4;
    static const int BOUNCE_SOUND_TICKS =  2;
    static const int GRAPH_HEIGHT       = 40;
    static const int GRAPH_SPACING      =  2;    
    static const int BoxWidth           = 50;
    static const int BoxHeight          = 25;
    
    static const char I2C_ADDR               = 0x1C << 1;
    static const int  Initial_Button_Timeout = 1500;

    int  ballX;
    int  ballY;
    int  circleX;
    int  circleY;
    int  ballSpeedX;
    int  ballSpeedY;
    int  paddleX;
    int  pwmTicksLeft;
    int  lives;
    int  graphX;    
    bool mode;
    bool lastUp;
    bool lastDown;
    unsigned short colors[3];
    
    DigitalIn  left;
    DigitalIn  right;
    DigitalIn  down;
    DigitalIn  up;
    DigitalIn  square;
    DigitalIn  circle; 
    DigitalOut led1;
    DigitalOut led2;

    PwmOut pwm;

    DisplayN18 disp;
    
    int echo_comands;
    
    int DEBUG;
    
    #define IPD    1
    #define PROMPT 2
    #define BUSY   3
    #define OK     4
    #define ERROR  5
    #define QUIT   6
    
    #define NMATCHES (sizeof(matchtab) / sizeof(match))
    
    char * Address_T;
    
    #if (0)
        char * Address_U = "192.168.0.14";                                
        char * Address_V = "192.168.0.22";                                
        char * Address_W = "192.168.0.23";
    #endif
    
    char * Address;
        
    static const char* SSID;
    static const char* PASSWORD;
    
    #ifndef AUTO_START    
        #if (0)
            const char ODOMETER[] = { '-', '|', '/', '-', '\\' };
        #endif
    #endif

    // Variables for Heartbeat and Status monitoring
    
    Ticker heartbeat;
    
    bool heartbeatflag;
    
    char BUFFER[21];
    char IPD_BUFFER[81];
    char UART_BUFFER[81];
    char FORMAT_BUFFER[81];
    
    I2C           i2c;
    SC16IS750_I2C serial_bridge1;
    SC16IS750_I2C serial_bridge2;
    DigitalOut esp8266_rst;
    
    char * pIPD_BUFFER;
    
    int mPROMPT, mIPD, mCOUNT, COUNT, uCOUNT, mCOLON, First;

    double CurrentTime, OldTime, ElapsedTime, Angle, Speed, R;
    
    uint64_t leftencoder, rightencoder, oldleftencoder, oldrightencoder;
    
    double convert(char* buffer);
    void printDouble(double value, int , int y);
    
    void drawAxes();
    void drawPoint(int axis, double value);
    void checkGraphReset();
    
    void initialize();
    void initializeBall();
    
    void drawString(const char* str, int y);
    
    void clearPaddle();
    void drawPaddle();
    void updatePaddle();
    
    void clearBall();
    void drawBall();
    void updateBall();
    
    void checkButtons();
    void checkCollision();
    void checkPwm();
    void checkLives();

    public:
        
        ROBOT();
        
        void showSplashScreen();
        void tick();
       
        void serial_print1(char * BUFFER);
        void serial_print2(char * BUFFER);
        void debug_print(unsigned int line, const char* function);
        void debug_print_string(unsigned int line, const char* function, char * pBUFFER);
        void debug_print2(unsigned int line, const char* function);
        void debug_print_string2(unsigned int line, const char* function, char * pBUFFER);
        void show_menu(void);
        void blink (DigitalOut LED);
        void pulse(void);
        void heartbeat_start(void);
        void heartbeat_stop(void);
        void ESP8266_reset(void);
        void reset_matchtab(void);
        int match_RESPONSES(char c, struct match table[], int n);
        int echo(int show, int timeout);
        double Hill(double x);
        double FastSin(double x);
        double FastCos(double x);
        int process_IPD(char c);
        void process_buttons(void);
        int terminal_emulator(int echo_comands, int timeout);
        void DrawBox(void);
        int test(void);
        void test2(void);
        int get_options(void);

};
