#include "mbed.h"
#include "ROBOT.h"
#include "SC16IS750.h"

//#define AUTO_START

#if defined(TARGET_LPC11U24)
    
    // SPI for LPC11U24
    
    #define D_MOSI                 p5
    #define D_MISO                 p6
    #define D_SCLK                 p7
    #define D_CS                   p8
    
    #define D_INTR                 P0_15   
    #define D_RST                  P0_22  

    // I2C for LPC11U24
    
    #define D_SCL                  P0_4
    #define D_SDA                  P0_5
    
    // Serial for LPC11U24
    
    #define D_TX                   USBTX
    #define D_RX                   USBRX
    
    //#define D_RST                p25
    //#define D_STS                p26
    
    #define ESP8266_RST            P0_10

    DigitalOut esp8266_rst(ESP8266_RST);

#endif

ROBOT robot;

char UART_BUFFER[81];

void debug_print(unsigned int line, const char* function) {    

    sprintf(UART_BUFFER, "%6d %s\r\n", line, function);            
    robot.serial_print2(UART_BUFFER);

    
}

void debug_print_string(unsigned int line, const char* function, char * text) {    

    sprintf(UART_BUFFER, "%6d %s %s\r\n", line, function, text);            
    robot.serial_print2(UART_BUFFER);

    
}

int main() {
    
    robot.showSplashScreen(); 
    
    robot.get_options();
    
    //while (true)
    //    robot.tick();  

}
