#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"

Serial pc(USBTX, USBRX); // tx, rx

MMA8451Q acc(PTE25,PTE24,0x1d<<1);

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut RedLED(PTA5);

int main()
{
    char count[3];
    char TxDataCnt;
    char temp;
    float x,y,z;
    

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2422);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple Transmitter (0 - 9 Counter) \r\n");

    TxDataCnt = 3;
    my_nrf24l01p.setTransferSize(TxDataCnt);

    my_nrf24l01p.enable();

    count[0] = 0x01;
    count[1] = 0x01;
    count[2] = 0x01;
    while (1) {
        x=acc.getAccX();
        y=acc.getAccY();
        z=acc.getAccZ();
        if(x>=0)
            count[0]=50*x;
        else
            count[0]=100+((-50)*x);
        if(y>=0)
            count[1]=50*y;
        else
            count[1]=100+((-50)*y);
        if(z>=0)
            count[2]=50*z;
        else
            count[2]=100+((-50)*z);
        // Send the Transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );

        //pc.printf( "Sending %d - x_axis--> %d y_axis-->%d z_axis-->%d\r\n",temp,count[0],count[1],count[2]);
        pc.printf( "Sending %d - x_axis--> %d y_axis-->%d z_axis-->%d\r\n",temp,x,y,z);
        
        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        RedLED = !RedLED;
        
        wait(1);
    }
}
